<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @package    theme_enlight
 * @copyright  2015 onwards LMSACE Dev Team (http://www.lmsace.com)
 * @authors    LMSACE Dev Team
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
 
defined('MOODLE_INTERNAL') || die();
 
function xmldb_theme_enlight_upgrade($oldversion) {
    $loggedin = get_config('moodle', 'frontpageloggedin');
	$aboutus = set_config( 'marketingSpot1_status', '1', 'theme_enlight');
	if (empty(get_config('theme_enlight', 'mspot1desc')) ) {
		set_config('mspot1desc', 'lang:aboutusdesc' ,'theme_enlight');
	} 
	if (empty(get_config('theme_enlight', 'mspot1title')) ) {
		set_config('mspot1title', 'lang:aboutus', 'theme_enlight');
	}
	$explog = array('6', '2', '5', '7');
	$data = array( 's__frontpageloggedin' => $explog );
	admin_write_settings($data);
	$explog = array('6', '2', '7');
	$data = array( 's__frontpage' => $explog );
	admin_write_settings($data);
	$newConfig = array(
		'availablecoursesbg_type' => '1', 
		'enrolledcoursesbg_type' => '1',
		'categoriesbg_type' => 'NONE'
		);
	foreach ($newConfig as $key => $value) {
		set_config($key, $value, 'theme_enlight');
	}
	$links = _generate_links('footerdesc1');
	set_config('footerdesc1', $links, 'theme_enlight');
    return true;
}

function _generate_links($menuname = '') {
    global $CFG, $PAGE;
    $htmlstr = '';
    $menustr = get_config('theme_enlight', $menuname);
    $menusettings = explode("\n", $menustr);
    foreach ($menusettings as $menukey => $menuval) {
        $expset = explode("|", $menuval);
        if (!empty($expset) && isset($expset[0]) && isset($expset[1])) {
            list($ltxt, $lurl) = $expset;
            $ltxt = trim($ltxt);
            $ltxt = _lang($ltxt);
            $lurl = trim($lurl);
            if (empty($ltxt)) {
                continue;
            }
            if (empty($lurl)) {
                $lurl = 'javascript:void(0);';
            }
            $pos = strpos($lurl, 'http');
            if ($pos === false) {
                $lurl = new moodle_url($lurl);
            }
            $htmlstr .= '<li><a href="'.$lurl.'">'.$ltxt.'</a></li>'."\n";
        }
    }
    return !empty($htmlstr) ? '<ul>'.$htmlstr.'</ul>' : $menustr;
}

function _lang($key='') {
    $pos = strpos($key, 'lang:');
    if ($pos !== false) {
        list($l, $k) = explode(":", $key);
        if (get_string_manager()->string_exists($k, 'theme_enlight')) {
            $v = get_string($k, 'theme_enlight');
            return $v;
        } else {
            return $key;
        }
    } else {
        return $key;
    }



}