// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @package    theme_enlight
 * @copyright  2015 onwards LMSACE Dev Team (http://www.lmsace.com)
 * @authors    LMSACE Dev Team
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

window.onload = function () { hideLoader(); }
function hideLoader() {
  loader = document.getElementById('theme_loader');
  var style = window.getComputedStyle(loader);
  if (style.display != 'none') {
    loader.style.visibility = "hidden";
  }
}
$(function(){

   img = $("header#header").find('.avatars').find('img[src$="/u/f2"]');
   src = img.attr('src');
   img.attr('src',src+'_white');
   msg = $("header#header").find('#nav-message-popover-container .nav-link').find("img[src$='t/message']");
   msgsrc = msg.attr('src');
   msg.attr('src', msgsrc+"_white");
   note = $("header#header").find('#nav-notification-popover-container .nav-link').find("img[src$='i/notifications']");
   notesrc = note.attr('src');
   note.attr('src', notesrc+"_white");


//**** Import Select alert for confirmation ****//
  $('input[name=s_theme_enlight_importDemo]').change(function(){
    $this = $(this);
    if ($(this).prop('checked') == true) {
      $msg = 'Importing demo content will override the current settings of the enlight theme and moodle frontpage items.';

      require(['core/notification'], function(notification) {
          notification.confirm('Please confirm', $msg, 'Continue', 'cancel', function() {

          }, function() {
             $this.prop('checked', false);
          });
      });

    }

  })


    $( "table" ).wrap(function(){
        var ctab_obj = $(this);
        if(ctab_obj.parent('div').hasClass('no-overflow'))
        {

        }else{
            return "<div class='no-overflow'></div>";
        }

    });

    par = $('#page');
    par.find('h2').each(function(){
      cont = $(this).html();
      con = cont.split(' ');
    })

   /* var wh = '_white';
/*     var si = setInterval(function(){

$(".block").each(function() {
var ctab_obj = $(this);
var dock_tar = ctab_obj.find(".block_action input[type='image']");
var dock_imgsrc = dock_tar.attr("src") || '';
if (dock_imgsrc != '') {
var  isunique = dock_imgsrc.indexOf(wh);
if (isunique == -1) {
dock_tar.attr('src', dock_imgsrc + "_white");
}
} */

/* var tg = ctab_obj.find(".block_action img").length;
if (tg > 0) {
ctab_obj.find(".block_action img").each(function(){
var cimg = $(this);
var cimg_src = cimg.attr("src");
var  isunique = cimg_src.indexOf(wh);
if (isunique == -1) {
cimg.attr("src", cimg_src + "_white");
}
});
}


var ac_mu = ctab_obj.find(".block-control-actions").length;
if (ac_mu > 0) {
var li_img = ctab_obj.find(".block-control-actions ul.menubar li img").length;
if (li_img > 0) {
ctab_obj.find(".block-control-actions ul.menubar li img").each(function(){
var cimg = $(this);
var cimg_src = cimg.attr("src");
var  isunique = cimg_src.indexOf(wh);
if (isunique == -1) {
cimg.attr("src",cimg_src + "_white");
}
});
}
}

});

$("table.flexible thead tr th, .generaltable thead tr th").each(function() {

$cobj = $(this);
var img_cnt = $cobj.find("img").length;
if(img_cnt > 0) {
var cimg = $cobj.find("img");
var cimg_src = cimg.attr("src");
var isunique = cimg_src.indexOf(wh);
if (isunique == -1) {
cimg.attr("src",cimg_src + "_white");
}
}

});

}, 1000);*/

      // setTimeout(function( ) { clearInterval( si ); }, 60000);

    // Settings For Scroll to top button.
    $(window).on('scroll', function(){
        if ($(this).scrollTop() > 150) {
            $('#backToTop').fadeIn('slow');
            $('#custom_save').fadeIn('slow');
        } else {
            $('#backToTop').fadeOut('slow');
        }
        if($(this).scrollTop() >= $(window).height) {
           $('#backToTop').fadOut('slow');

        }

    });
    $('#backToTop').click(function(){
        $("html, body").animate({ scrollTop: 0 }, 'slow');
        return false;
    });

    /*------- Check navbar button status -------- */
    if ($("#header .navbar-nav button").attr('aria-expanded') === "true") {
      $("#header .navbar-nav").find('button').addClass('is-active');
    }
    /*------ Event for change the drawer navbar style  ------*/
    $("#header .navbar-nav button").click(function(){
      $this = $(this);
      setTimeout(function() {
        if ($this.attr('aria-expanded') === "true") {
          $("#header .navbar-nav").find('button').addClass('is-active');
        } else {
           $("#header .navbar-nav").find('button').removeClass('is-active');
        }
      }, 200);
    });

    // Add class name with the frontpage enrolled courses block for the reference.
    $("#mycourses").parent('div#frontpage-course-list').addClass("frontpage-mycourse-list");

   /*----------------- Site news block allignment changes start here ----------- */
   $("#site-news-forum .forumpost").each(function() {
        $this = $(this);
        $href = $(this).find('.row.side .commands').find('a:first').attr('href');

        img = $this.find('.attachedimages img');
        if (img.length != ""){
            img.wrap('<a href="'+$href+'" />');
        }
        $this.find('.topic .subject').contents().wrap('<a href="'+$href+'" /> ');
   })
   $("#site-news-forum .forumpost:gt(0)").wrapAll('<div class="site-block"></div>');
   $img = $("#site-news-forum .forumpost:first").find('.attachedimages');
   //alert($img);
     if ($img.length == "") {
        $('#site-news-forum .forumpost:first').find(".maincontent .posting").prepend("<div class='attachedimages'></div>");
     }
     $("#site-news-forum .forumpost:gt(0)").each(function(){
        $this = $(this);
        $imgContent = $(this).find('.attachedimages img');
        if($imgContent.length == "") {
          if($("body").hasClass('dir-rtl')) {
            $this.attr('style', 'padding-right: 20px !important');
          } else {
            $this.attr('style', 'padding-left: 20px !important');
          }
            $this.find('.left.picture').show();
        }
    })

    $("#site-news-forum").append("<div class='clearfix'></div>");

   /*----------------- Site news block allignment changes end here ----------- */


    // Enable/Disable the popular course id field in admin settings page on PAGE LOADING.
    $val = $("#id_s_theme_enlight_popularCourse_type").val();
    if ($val == 1) {
      $("#admin-popularCourse_id").find('input[type=text]').attr('disabled','disabled');
    }

    // Enable/ Disable popular course id on the values based on popular course type.
    $("#id_s_theme_enlight_popularCourse_type").on('change', function() {

      $this = $(this);
      val = $this.val();
      if (val=='1') {
        $("#admin-popularCourse_id").find('input[type=text]').attr('disabled','disabled');
      } else {
        $("#admin-popularCourse_id").find('input[type=text]').removeAttr('disabled');
      }
    });


  /*----- Create the accordion for the custom blocks or tabs in settings page */
  var toggelSection = ['#theme_enlight_general', '#theme_enlight_slideshow','#theme_enlight_tmonialhead', '#theme_enlight_ourTeam', '#theme_enlight_marketingspot', '#theme_enlight_footer'];
  $.each(toggelSection, function(key, value) {
    h3 = $(value).find('h3.main');
    block = value.split("_")[2]; // Get the settings heading name from the given id's.
    h3.each(function(key) {
      $this = $(this);
      var childid = block+"_toggle_"+key;
      hidden = "true";
      var toggleChild = '<div class="child-toggle '+childid+'" id="child_'+childid+'" data-hidden="'+hidden+'" />';
      $(this).nextUntil('h3.main').wrapAll(toggleChild);
      var toggleHead = '<div class="enlight-toggle-head" id="'+childid+'">';
      $this.wrap(toggleHead);
      iconclass = (hidden == "false") ? 'fa-minus-square' : 'fa-plus-square';
      var toggleIcon = '<div class="toggle-icon" style="display:inline;" > <i class="fa '+iconclass+'"> </i></div>';
      $this.append(toggleIcon);
    })

  })

  /******** Event for accordion clicked  *********/
  $(".enlight-toggle-head").click(function(){
    $this= $(this);
    parentid = $this.parent('fieldset').parent('div.tab-pane').attr('id');
     if(parentid.length != "") {
      parent = $("#"+parentid);
    } else {
      parent = $(".tab-pane.active[aria-expanded=true]");
    }
    headid = $this.attr('id');
    childid = "child_"+headid;
    child = $("#"+childid);
    var dataHidden = $("#"+childid).attr('data-hidden');
    if(dataHidden == "false"){
      child.slideUp('slow');
      child.attr('data-hidden', 'true');
    } else {
      child.slideDown('slow');
      child.attr('data-hidden', 'false');
    }
    parent.find('.child-toggle').not(child).slideUp('slow').attr('data-hidden', 'true');

    toggleicon2(parentid);
  })


  /******** Set the icon for all accortions under the active parent tab *********/
  function toggleicon2(parentid) {
    //alert(parentid);
    if(parentid.length != "") {
      parent = $("#"+parentid);
    } else {
      parent = $(".tab-pane.active[aria-expanded=true]");
    }
    parent.find('.enlight-toggle-head').each(function() {
      $this = $(this);
      childid = $(this).attr('id');
     // alert(childid)
      dataHidden = parent.find('#child_'+childid).attr('data-hidden');
      if(dataHidden == "false") {
        $this.find('h3 .toggle-icon i').addClass('fa-minus-square').removeClass('fa-plus-square');
      } else {
        $this.find('h3 .toggle-icon i').addClass('fa-plus-square').removeClass('fa-minus-square');
      }
    });

  }

  $(".child-toggle[data-hidden=true]").hide();


  /*============== Course Mega menu ===============*/
  if ($('body').hasClass('dir-rtl')) {

    var w =  $(".header-main #sgkk").width();
     var win = $(window).width();
     if(win>=980)
     {
       var ul_w =  $(".header-main #site-user-menu ul").width();
       var le = ( w-ul_w );
       $('#cr_menu').css({"width":w+'px' , "right": '-'+le+'px' });
     }

      $(window).resize(function(){
       var w =  $(".header-main #sgkk").width();
       var win = $(window).width();
       if(win>=980)
       {
         var ul_w =  $(".header-main #site-user-menu ul").width();
         var le = ( w-ul_w );
         $('#cr_menu').css({"width":w+'px' , "right": '-'+le+'px' });
       }
    });


  } else { // RTL Check And RTL BASED Function;

     var w =  $(".header-main #sgkk").width();
     var win = $(window).width();
     if(win>=980)
     {
       var ul_w =  $(".header-main #site-user-menu ul").width();
       var le = ( w-ul_w );
       $('#cr_menu').css({"width":w+'px' , "left": '-'+le+'px' });
     }

      $(window).resize(function(){
       var w =  $(".header-main #sgkk").width();
       var win = $(window).width();
       if(win>=980)
       {
         var ul_w =  $(".header-main #site-user-menu ul").width();
         var le = ( w-ul_w );
         $('#cr_menu').css({"width":w+'px' , "left": '-'+le+'px' });
       }
    });


  }


    $("#cr_link").mouseenter(function() {
       $("#cr_link").addClass("active");
        // $('#cr_menu').stop(true, true).show(400);
       $('#cr_menu').show();
    });

    $("#cr_link").mouseleave(function() {
      $("#cr_link").removeClass("active");
      // $('#cr_menu').stop(true, true).hide(400);
      $('#cr_menu').hide();
    });


});