<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @package    theme_enlight
 * @copyright  2015 onwards LMSACE Dev Team (http://www.lmsace.com)
 * @authors    LMSACE Dev Team
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

global $CFG, $PAGE;
user_preference_allow_ajax_update('drawer-open-nav', PARAM_ALPHA);
require_once($CFG->libdir . '/behat/lib.php');

if (isloggedin()) {
    $navdraweropen = (get_user_preferences('drawer-open-nav', 'true') == 'true');
} else {
    $navdraweropen = false;
}
$extraclasses = [];
if ($navdraweropen) {
    $extraclasses[] = 'drawer-open-left';
}
$bodyattributes = $OUTPUT->body_attributes($extraclasses);
$blockshtml = $OUTPUT->blocks('side-pre');
$hasblocks = strpos($blockshtml, 'data-block=') !== false;
$regionmainsettingsmenu = $OUTPUT->region_main_settings_menu();

$surl = new moodle_url('/course/search.php');
$courserenderer = $PAGE->get_renderer('core', 'course');
$tcmenu = $courserenderer->top_course_menu();
$cmenuhide = theme_enlight_get_setting('cmenuhide');
//$primarymenu = theme_enlight_primary_menuitems();


$curl = new moodle_url('/course/index.php');
$logourl = theme_enlight_get_logo_url();
$topmmenu = $tcmenu['topmmenu'];
$topcmenu = $tcmenu['topcmenu'];
$s_home = get_string('home');
$cmenuhide = (!$cmenuhide) ? 0 : 1 ;
$s_courses = get_string('courses');

// Footer Blocks.
$copyright = theme_enlight_get_setting('copyright');
$copyright = theme_enlight_lang($copyright);
$fb1title = theme_enlight_get_setting('footerbtitle1', 'format_text');
$fb1title = theme_enlight_lang($fb1title);
$fb2title = theme_enlight_get_setting('footerbtitle2', 'format_text');
$fb2title = theme_enlight_lang($fb2title);
$fb3title = theme_enlight_get_setting('footerbtitle3', 'format_text');
$fb3title = theme_enlight_lang($fb3title);
$fb4title = theme_enlight_get_setting('footerbtitle4', 'format_text');
$fb4title = theme_enlight_lang($fb4title);
$footerblink1 = theme_enlight_get_setting('footerdesc1');
$footerblink1 = theme_enlight_lang($footerblink1);
$social_links = theme_enlight_social_links();
$footerblink3 = theme_enlight_generate_links('footerblink3');
$footerblink2 = theme_enlight_generate_links('footerblink2');

$backToTop_status = theme_enlight_get_setting('backToTop_status');
$footerb1 = theme_enlight_get_setting('footerb1_status');
$footerb2 = theme_enlight_get_setting('footerb2_status');
$footerb3 = theme_enlight_get_setting('footerb3_status');
$footerb4 = theme_enlight_get_setting('footerb4_status');
$totalEnable = $footerb1 + $footerb2 + $footerb3 + $footerb4;
$footermain = 1;

switch($totalEnable) {
    case 4 :
        $colClass = 'col-md-3';
    break;

    case 3:
        $colClass = 'col-md-4';
    break;

    case 2:
        $colClass = 'col-md-6';
    break;

    case 1:
        $colClass = 'col-md-12';
    break;

    case 0:
        $footermain = 0;
        $colClass = '';
    break;

    default:
        $colClass = 'col-md-3';
}
$theme_loader = get_theme_loader();
$headerStyle = theme_enlight_header_style();



$templatecontext = [
    'sitename' => format_string($SITE->shortname, true, ['context' => context_course::instance(SITEID), "escape" => false]),
    'output' => $OUTPUT,
    'sidepreblocks' => $blockshtml,
    'hasblocks' => $hasblocks,
    'bodyattributes' => $bodyattributes,
    'navdraweropen' => $navdraweropen,
    'regionmainsettingsmenu' => $regionmainsettingsmenu,
    'hasregionmainsettingsmenu' => !empty($regionmainsettingsmenu),
    "curl" => $curl,
    "logourl" => $logourl,
    "topmmenu" => $topmmenu,
    "topcmenu" => $topcmenu,
    "s_home" => $s_home,
    "cmenuhide" => $cmenuhide,
    "s_courses" => $s_courses,
    'output' => $OUTPUT,
    "copyright" => $copyright,
    "fb1title" => $fb1title,
    "fb2title" => $fb2title,
    "fb3title" => $fb3title,
    "fb4title" => $fb4title,
    "social_links" => $social_links,
    "footerblink3" => $footerblink3,
    "footerblink2" => $footerblink2,
    "footerblink1" => $footerblink1,
    "footerb1" => $footerb1,
    "footerb2" => $footerb2,
    "footerb3" => $footerb3,
    "footerb4" => $footerb4,
    "colClass" => $colClass,
    "footermain" => $footermain,
    "backToTop" => $backToTop_status,
    'headerStyle' => $headerStyle,
    "theme_loader" => $theme_loader
];

$templatecontext['flatnavigation'] = $PAGE->flatnav;
echo $OUTPUT->render_from_template('theme_enlight/columns2', $templatecontext);
?>


