<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @package    theme_enlight
 * @copyright  2015 onwards LMSACE Dev Team (http://www.lmsace.com)
 * @authors    LMSACE Dev Team
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
defined('MOODLE_INTERNAL') || die;

require_once($CFG->libdir.'/adminlib.php');
require_once($CFG->dirroot.'/course/externallib.php');
require_once($CFG->dirroot.'/files/externallib.php');
require_once($CFG->dirroot.'/lib/filestorage/file_storage.php');

require_login(0, false);
$PAGE->set_context(context_system::instance());
/**
 * Class For The Enlight Demo Importer.
 */
class enlightDemoImport{

    public $config = "";
    public $categoryid = "";
    public $courseid = "";

    /**
     * Class construct function. Autocall off the functions
     * @return type
     */
    function __construct(){
        global $CFG, $PAGE;
       if ($PAGE->theme->settings->importDemo == 1) {

            $this->clear_import();
            $this->config = $this->enlight_import_json_content();
            $this->url = $this->theme_enlight_get_images();
            $this->enlight_set_frontpageloggedin();
            $categoryid = $this->enlight_demo_create_category();
            $courseid = $this->enlight_import_demo_courses($categoryid);
            $this->courseid = $courseid;
            $this->categoryid = $categoryid;
            $this->setCategoryBgimages($categoryid);
            $this->enlight_import_all_images();
        }
    }
    /**
     * Get the images fromt the demo url.
     * @return type
     */
    public function theme_enlight_get_images() {
        $images = isset($this->config['images']['general']) ? $this->config['images']['general'] : array();
        return $images;
    }
    /**
     * Get the category images.
     * @return type
     */
    public function category_images() {

        $images = isset($this->config['images']['category']) ? $this->config['images']['category'] : array();
        return $images;
    }

    /**
     * Load and set the frontpage loggedin user display blocks arrangement on moodle/
     * @return type
     */
    public function enlight_set_frontpageloggedin() {

        $value = isset($this->config['frontpage']['s__frontpageloggedin']) ? $this->config['frontpage']['s__frontpageloggedin'] : "" ;
        $value2 = isset($this->config['frontpage']['s__frontpage']) ? $this->config['frontpage']['s__frontpage'] : "" ;
        if (!empty($value)) {
            $data = array( 's__frontpageloggedin' => $value );
            $data2 = array('s_frontpage' => $value2);
            admin_write_settings($data);
            admin_write_settings($data2);
        }
    }

    /**
     * Import the json contents fromt the url.
     * @return type
     */
    public function enlight_import_json_content() {
        global $CFG;
        $json_url = "http://lmsace.com/theme-import/enlight-v15/data.json";
        $json = file_get_contents($json_url);
        $config = json_decode($json, true);
        array_walk_recursive($config, 'enlightDemoImport::html_decode');

        $this->config = $config;
        if (!empty($config)){
            $this->enlight_import_general_settings();
            $this->enlight_import_homepageSlider_settings();
            $this->enlight_import_marketingspot_settings();
            $this->enlight_set_ourTeam_config();
            $this->enlight_set_testimonials_config();
            $this->enlight_set_footer_config();
        }

         return $config;
    }


    /**
     * Create and load the general settings.
     * @return type
     */
    public function enlight_import_general_settings() {
        $config = $this->config;
        if (isset($config['general']) && !empty($config['general'])) {
            foreach ($config['general'] as $key => $value)  {
                $this->enlight_set_config($key, $value);
            }
        }
    }
    /**
     * Load the homepage slider settings
     * @return type
     */
    public function enlight_import_homepageSlider_settings() {
        if (isset($this->config['homepage_slider']) && !empty($this->config['homepage_slider']) ) {
            $this->enlight_load_config($this->config['homepage_slider']);

        }

    }
    public function enlight_import_marketingspot_settings() {
        if (isset($this->config['marketing_spots']) && !empty($this->config['marketing_spots']) ) {
            $this->enlight_load_config($this->config['marketing_spots']);
        }
    }

    public function enlight_set_ourTeam_config() {
        if (isset($this->config['ourteam']) && !empty($this->config['ourteam']) ) {
            $this->enlight_load_config($this->config['ourteam']);
        }
    }
    public function enlight_set_testimonials_config(){
        if (isset($this->config['testimonials']) && !empty($this->config['testimonials']) ) {
            $this->enlight_load_config($this->config['testimonials']);
        }
    }
    public function enlight_set_footer_config(){
        if (isset($this->config['footer_blocks']) && !empty($this->config['footer_blocks']) ) {
            $this->enlight_load_config($this->config['footer_blocks']);
        }
    }


    public function enlight_load_config($options = array() ) {
        if (isset($options) && !empty($options)) {
            foreach ($options as $key => $value) {
                if (is_array($value)) {
                    $this->enlight_load_config($options[$key]);
                } else {
                    $this->enlight_set_config($key, $value);
                }
            }
        }
    }

    public function enlight_demo_create_category() {
        global $CFG;
        $category = $this->enlight_demo_category_list();
        if (!empty($category)) {
            $result = core_course_external::create_categories($category);
            if (!empty($result)) {
                foreach ($result as $key => $value) {
                    $categoryid[$key] = $value['id'];
                }
            }
        }
        return $categoryid;
    }

    public function setCategoryBgimages($categoryid=array()) {
        if (!empty($categoryid)) {
            foreach($categoryid as $key => $value) { // Index => categoryid.
                $imageurl = $this->category_images();
                if (isset($imageurl["categoryimg$key"]) && !empty($imageurl["categoryimg$key"])) {
                    $name = 'category_'.$value.'.jpg';

                    $path = $this->enlight_upload_images('categoryimg'.$value, $name, $imageurl["categoryimg$key"]);
                    if (!empty($path)){
                        $this->enlight_set_config('categoryimg'.$value, '/'.$name);
                    }
                }
            }
        }
    }

    protected function enlight_set_config($key, $value) {
        set_config($key, $value, 'theme_enlight');
    }

    public function enlight_upload_images($type, $name, $url) {
        $fs = get_file_storage();
        if (isset($url)) {
            $filerecord = new stdClass();
            $filerecord->component = 'theme_enlight';
            $filerecord->contextid = context_system::instance()->id;
            $filerecord->userid    = get_admin()->id;
            $filerecord->filearea  = $type;
            $filerecord->filepath  = '/';
            $filerecord->itemid    = 0;
            $filerecord->filename  = $name;
            $exist =  $fs->file_exists($filerecord->contextid, $filerecord->component, $filerecord->filearea, $filerecord->itemid, $filerecord->filepath, $filerecord->filename);
            if ($exist == 1) {
                $fs->delete_area_files($filerecord->contextid, $filerecord->component, $filerecord->filearea, $filerecord->itemid);
            }
            $fs->create_file_from_url($filerecord, $url);
            $url = $this->enlight_get_images($filerecord);
            return $url;
        }
    }

    public function enlight_import_all_images() {
        if (!empty($this->url)) {
            foreach($this->url as $key => $value) {
                if ($value) {
                    $hashname = get_config('theme_enlight', $key);
                    $this->remove_image($key, $hashname);
                    $result = $this->enlight_upload_images($key, $key.".jpg", $value);
                    if (!empty($result)) {
                        $this->enlight_set_config($key, '/'. $key.".jpg");
                    }
                }
            }
        }
    }
    public function remove_image($key, $hashname = "") {

            $fs =get_file_storage();
            $filerecord = new stdClass();
            $filerecord->component = 'theme_enlight';
            $filerecord->contextid = context_system::instance()->id;
            $filerecord->userid    = get_admin()->id;
            $filerecord->filearea  = $key;
            $filerecord->filepath  = '/';
            $filerecord->itemid    = 0;
            $filerecord->filename  = $hashname;
        $exist =  $fs->file_exists($filerecord->contextid, $filerecord->component, $filerecord->filearea, $filerecord->itemid, $filerecord->filepath, $filerecord->filename);

            if ($exist == 1) {
                $fs->delete_area_files($filerecord->contextid, $filerecord->component, $filerecord->filearea);
            }
    }

    public function enlight_get_images($filerecord = array()){
        $fs = get_file_storage();
        if (!empty($filerecord)) {
            $files = $fs->get_area_files($filerecord->contextid, $filerecord->component, $filerecord->filearea, $filerecord->itemid, 'timemodified ASC', false);

            foreach ($files as $file) {
                $url = moodle_url::make_pluginfile_url(
                            $file->get_contextid(),
                            $file->get_component(),
                            $file->get_filearea(),
                            $file->get_itemid(),
                            $file->get_filepath(),
                            $file->get_filename()
                        );
            }
        }
        return $url;
    }

    public function enlight_import_demo_courses($categoryid) {
        $courseid = array();
        $courses = $this->demo_courses_list($categoryid);
        if (!empty($courses)){
            $result = core_course_external::create_courses($courses);
            if (!empty($result)) {
                foreach($result as $key => $value) {
                    $courseid[$key] = $value;
                }

            }
        }
        return $courseid;
    }

    public function enlight_demo_category_list() {

        $category1 = array(
            'name' => 'Web Development',
            'parent' => '0',
            'description' => 'This category is created for the dummy purpose'
        );

        $category2 = array(
            'name' => 'Software Engineering',
            'parent' => '0',
            'description' => 'This category is created for the dummy purpose'
        );

        $category3 = array(
            'name' => 'IOS Development',
            'parent' => '0',
            'description' => 'This category is created for the dummy purpose'
        );

        $category4 = array(
            'name' => 'Digital Marketing',
            'parent' => '0',
            'description' => 'This category is created for the dummy purpose'
        );

        $category5 = array(
            'name' => 'Business Management',
            'parent' => '0',
            'description' => 'This category is created for the dummy purpose'
        );
        $category6 = array(
            'name' => 'Android Development',
            'parent' => '0',
            'description' => 'This category is created for the dummy purpose'
        );
        $category7 = array(
            'name' => 'IT Risk Management',
            'parent' => '0',
            'description' => 'This category is created for the dummy purpose'
        );
        $category8 = array(
            'name' => 'IT Security',
            'parent' => '0',
            'description' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam placerat auctor consequat. Ut quis iaculis erat, suscipit maximus tortor.'
        );

        $category = array($category1, $category2, $category3, $category4, $category5, $category6, $category7, $category8);
        return $category;
    }

    public function demo_courses_list($categoryid) {
        $courses = array();
        $time = time();
        $course1 = array(
            "fullname" => "Html 5",
            "shortname" => "html_5_".$time."1",
            'categoryid' => (isset($categoryid[0]) && !empty($categoryid[0]) ) ? $categoryid[0] : "1",
            "summary" => "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam placerat auctor consequat. Ut quis iaculis erat, suscipit maximus tortor. "
        );
        $course2 = array(
            "fullname" => "Software Engineering",
            "shortname" => "software-engineering_".$time."2",
            'categoryid' => (isset($categoryid[1]) && !empty($categoryid[1]) ) ? $categoryid[1] : "1",
            "summary" => "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam placerat auctor consequat. Ut quis iaculis erat, suscipit maximus tortor. "
        );
        $course3 = array(
            "fullname" => "Objective-c",
           "shortname" => "objective-c_".$time."3",
            'categoryid' => (isset($categoryid[2]) && !empty($categoryid[2])) ? $categoryid[2] : "1",
            "summary" => "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam placerat auctor consequat. Ut quis iaculis erat, suscipit maximus tortor. "
        );
        $course4 = array(
            "fullname" => "Digital Marketing",
            "shortname" => "digital-marketing_".$time."4",
            'categoryid' => (isset($categoryid[3]) && !empty($categoryid[3])) ? $categoryid[3] : "1",
            "summary" => "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam placerat auctor consequat. Ut quis iaculis erat, suscipit maximus tortor."
        );
        $course5 = array(
            "fullname" => "Business Law.",
            "shortname" => "business_law_".$time."5",
            'categoryid' => (isset($categoryid[4])&& !empty($categoryid[4])) ? $categoryid[4] : "1",
            "summary" => "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam placerat auctor consequat. Ut quis iaculis erat, suscipit maximus tortor.  "
        );
        $course6 = array(
            "fullname" => "Android",
            "shortname" => "android_".$time."6",
            'categoryid' => (isset($categoryid[5])&& !empty($categoryid[5])) ? $categoryid[5] : "1",
            "summary" => "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam placerat auctor consequat. Ut quis iaculis erat, suscipit maximus tortor. "
        );
        $course7 = array(
            "fullname" => "Risk Management",
            "shortname" => "risk_management_".$time."7",
            'categoryid' => (isset($categoryid[6])&& !empty($categoryid[6])) ? $categoryid[6] : "1",
            "summary" => "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam placerat auctor consequat. Ut quis iaculis erat, suscipit maximus tortor."
        );
        $course8 = array(
            "fullname" => "Information Security Management",
            "shortname" => "it_security_management_".$time."8",
            'categoryid' => (isset($categoryid[7])&& !empty($categoryid[7])) ? $categoryid[7] : "1",
            "summary" => "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam placerat auctor consequat. Ut quis iaculis erat, suscipit maximus tortor. "
        );

        $courses = array($course1, $course2, $course3, $course4, $course5, $course6,$course7,$course8);

        return $courses;

    }

    public function clear_import() {
        set_config('importDemo', '0', 'theme_enlight');
    }

    public static function html_decode(&$item, $key) {
        $item = html_entity_decode($item);
    }
}





?>