<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @package    theme_enlight
 * @copyright  2015 onwards LMSACE Dev Team (http://www.lmsace.com)
 * @authors    LMSACE Dev Team
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

// Get the HTML for the settings bits.

$html = theme_enlight_get_html_for_settings($OUTPUT, $PAGE);

if (right_to_left()) {
    $regionbsid = 'region-bs-main-and-post';
} else {
    $regionbsid = 'region-bs-main-and-pre';
}


$PAGE->requires->js('/theme/enlight/javascript/bootstrap-transition.js');
$courserenderer = $PAGE->get_renderer('core', 'course');

echo $OUTPUT->doctype() ?>
<html <?php echo $OUTPUT->htmlattributes(); ?>>
<head>
    <title><?php echo $OUTPUT->page_title(); ?></title>
    <link rel="shortcut icon" href="<?php echo $OUTPUT->favicon(); ?>" />
    <?php echo $OUTPUT->standard_head_html() ?>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
<!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=UA-96651518-1"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'UA-96651518-1');
</script>

</head>


<body class="pagelayout-mydashboard" <?php echo $OUTPUT->body_attributes(); ?>>

<?php echo $OUTPUT->standard_top_of_body_html() ?>

<?php  require_once(dirname(__FILE__) . '/includes/header.php');  ?>

<div class="navdrawer-overlay" id="sidebar_overlay"></div>
<!--Custom theme header-->
<div class="page slide" >
    <?php
    require_once(dirname(__FILE__) . '/includes/slideshow.php'); 
       

    ?>
    <!--Custom theme slider-->
    <link rel="stylesheet" href="<?php echo theme_enlight_theme_url(); ?>/style/slick.css" />
    <script src="<?php echo theme_enlight_theme_url(); ?>/javascript/slick.js"></script>

   
    <!--Popular Courses-->
    <?php 
        echo $courserenderer->popular_courses();
    ?>
    <!--E.O.Popular Courses-->



    <!--About Us-->

    <?php
    $status = theme_enlight_get_setting('marketingSpot1_status');
    if ($status == "1") {
        echo theme_enlight_marketingspot1();    
    }
    ?>
    <!--E.O.About Us-->


    <!-- Marketing Spot 1 -->
    <?php
    
    $ms1_status = theme_enlight_get_setting('marketingSpot1_status');
    if ($ms1_status == 1) {
    ?>
        <div class="frontpage-siteinfo hidden">
            <div class="siteinfo-bgoverlay">
                <div class="container">
                <?php
                $msp1title = theme_enlight_get_setting('mspot1title', 'format_text');
                $msp1title = theme_enlight_lang($msp1title);
                $msp1desc = theme_enlight_get_setting('mspot1desc', 'format_text');
                $msp1desc = theme_enlight_lang($msp1desc);
                echo '<h1>'.$msp1title.'</h1>';
                echo '<p>'.$msp1desc.'</p>';
                ?>
                </div>
            </div>
        </div>
    <?php
    }
    ?>

    <!--E.O.Marketing Spot 1 -->

    <div id="page" class="enlight-frontpage" style="">
    <header id="page-header" class="clearfix">
        <div id="course-header">
            <?php echo $OUTPUT->course_header(); ?>
        </div>
    </header>
    <div id="page-content">

        <div id="<?php echo $regionbsid ?>" >
                    <?php
                        echo $OUTPUT->course_content_header();
                        echo $OUTPUT->main_content();
                        echo $OUTPUT->course_content_footer();
?>
        </div>
                <?php echo $OUTPUT->blocks('side-pre', 'col-md-3'); ?>

    </div>
</div>

</div>



    <!--Testimonials-->
    <?php
    /*================ Our Team Block =============== */
    $ourteamStatus = theme_enlight_get_setting('ourteamStatus');
    if ($ourteamStatus != 0 ) {
        echo theme_enlight_our_team();
    }
    /*=============== Our Team Block End Here =========== */

    /*======================= Testimonials Block =================*/

    echo theme_enlight_tmonials();

    /*======================= Testimonials Block End Here =========== */

    

    $theme = theme_config::load('enlight');
    $ourteamAutoplay = theme_enlight_get_setting('ourteamAutoplay');
    $autoplay = theme_enlight_get_setting('testimonialAutoplay');
    $pagination = theme_enlight_get_setting('tmonialTraversal_status');
    $pagination = ($pagination == "1") ? "true" : "false";
    $autoplay = ($autoplay == "1") ? "true" : "false";
    $ourteamAutoplay = ($ourteamAutoplay == "1") ? "true" : "false";

    ?>
    <!--E.O.Testimonials-->

    <?php
    $mspot2status = theme_enlight_get_setting('marketingSpot2_status');
    $msp2title = theme_enlight_get_setting('mspot2title', 'format_text');
    $msp2title = theme_enlight_lang($msp2title);
    $msp2desc = theme_enlight_get_setting('mspot2desc', 'format_text');
    $msp2desc = theme_enlight_lang($msp2desc);
    $msp2url = theme_enlight_get_setting('mspot2url');
    $msp2urltxt = theme_enlight_get_setting('mspot2urltext', 'format_text');
    $msp2urltxt = theme_enlight_lang($msp2urltxt);
    $mspot2urltarget = theme_enlight_get_setting('mspot2urltarget');
    $target = ($mspot2urltarget == '1') ? "_blank" : "_self";
    if ($mspot2status == '1') {
    ?>
    <div class="jumbo-viewall">
     <div class="container">
         <div class="inner-wrap">
             <div class="desc-wrap">
                    <h2><?php echo $msp2title; ?></h2>
                    <p><?php echo $msp2desc; ?></p>
                </div>
            <a href='<?php echo $msp2url; ?>' target="<?php echo $target;?>" class="btn-jumbo"><?php echo $msp2urltxt; ?></a>
                </div>
     </div>
    </div>
    <?php } ?>
    <?php echo ($flatnavbar) ? $flatnavbar: ''; ?>

<!-- Marketing Spot 2 -->

<?php
    $mycourse_displaytype = theme_enlight_get_setting('mycourse_displaytype');
    $mycourseClass = ($mycourse_displaytype == 0) ? "frontpageblock-default" : "frontpageblock-theme"; 

    $categories_displaytype = theme_enlight_get_setting('categories_displaytype');
    $categoriesClass = ($categories_displaytype == 0) ? "frontpageblock-default" : "frontpageblock-theme"; 

    $availablecourse_displaytype = theme_enlight_get_setting('availablecourse_displaytype');
    $availableClass = ($availablecourse_displaytype == 0) ? "frontpageblock-default" : "frontpageblock-theme"; 
?>
<script type="text/javascript">

$(document).ready(function() {

    var availableClass = "<?php echo $availableClass;?>";
    var categoriesClass = "<?php echo $categoriesClass; ?>";
    var mycourseClass = "<?php echo $mycourseClass; ?>";
    
    $("#frontpage-course-list #available-courses").parents('div#frontpage-course-list').addClass('frontpage-available-course '+availableClass);
    $("#frontpage-course-list #mycourses").parents('div#frontpage-course-list').addClass('frontpage-mycourse-list');
    $(".frontpage-course-list-enrolled").parents('div#frontpage-course-list').addClass('frontpage-mycourse-list '+ mycourseClass);
    $("#frontpage-category-names").addClass(categoriesClass);

    if($('body').hasClass('dir-rtl')) {
        var rtl = true;
    } else {
        var rtl = false;
    }
    var autoplay = <?php echo $autoplay;?>;
    var pagination = <?php echo $pagination;?>;
    $("#Carouseltestimonials").slick({
        //arrows:true,
        swipe:true,
        infinite: true,
        slidesToShow: 1,
        slidesToScroll: 1,
        dots: pagination,
        prevArrow:false,
        nextArrow:false,
        speed:1000,
        autoplay: autoplay,
        rtl:rtl,
        adaptiveHeight: true
    });

})
</script>


<?php
if (right_to_left()) {
    $rtl = "true";
} else {
    $rtl = "false";
}
?>




<script>    

$(function(){

    var rtl = <?php echo isset($rtl) ? $rtl : false; ?>;
    var ourteamAutoplay = <?php echo $ourteamAutoplay;?>;
    if (rtl == "") {
        if($('body').hasClass('dir-rtl')){ rtl = true } else { rtl = false }      
    }

    $(".course-slider").slick({
        arrows:true ,
        swipe:true,
        prevArrow:'#available-courses .pagenav .slick-prev',
        nextArrow: '#available-courses .pagenav .slick-next',
        rtl:rtl
    });

    var prow = $(".course-slider").attr("data-crow");
    prow = parseInt(prow);
    if(prow < 2)
    {
      $("#available-courses .pagenav").hide();
    }

    $(".mycourse-slider").slick({
        arrows:true ,
        swipe:true,
        prevArrow:'#mycourses .pagenav .slick-prev',
        nextArrow: '#mycourses .pagenav .slick-next',
        rtl:rtl
    });

    var prow = $(".mycourse-slider").attr("data-crow");
    prow = parseInt(prow);
    if(prow < 2) {
        $("#mycourses .pagenav").hide();
    }


    $(".list_categories").slick({
        arrows:true ,
        swipe:true,
        prevArrow:'#Listcategories .pagenav .slick-prev',
        nextArrow: '#Listcategories .pagenav .slick-next',
        rtl:rtl
    });

    var prow = $(".list_categories").attr("data-crow");
    prow = parseInt(prow);
    if(prow < 2) {
        $("#Listcategories .pagenav").hide();
    }


    $(".popular_courses").slick({
        arrows:true ,
        swipe:true,
        prevArrow:'#Popular-Courses .pagenav .slick-prev',
        nextArrow: '#Popular-Courses .pagenav .slick-next',
        rtl:rtl
    });

    var prow = $(".popular_courses").attr("data-crow");
    prow = parseInt(prow);
    if(prow < 2) {
        $("#Popular-Courses .pagenav").hide();
    }

  
    if (ourteamAutoplay == '') {
        ourteamAutoplay = "false";
    }
    $(".our_team_slider").slick({
        arrows:true ,
        swipe:true,
        prevArrow:'.our-team .pagenav .slick-prev',
        nextArrow:'.our-team .pagenav .slick-next',
        autoplay: ourteamAutoplay,
        rtl:rtl
    }); 

});
</script>

<?php


require_once(dirname(__FILE__) . '/includes/footer.php');  ?>

<!--Custom theme footer-->
<style>
.load-content {
    display: none;
}

</style>
<?php if ( $type = theme_enlight_combolist_type() == true) {
?>
<script>
$(function(){

 $(".course_category_tree").find('.category.loaded').each(function(){ $(this).addClass('collapsed').attr('aria-expanded', 'false'); });

       
});

</script>
<?php
}
?>

<style type="text/css"> 
@media(min-width:768px) {
    body.drawer-open-left {
        margin-left: 0;
    }
}
.navdrawer-overlay {
     width: 100%;
    height: 100%;
    background: rgba(0, 0, 0, 0.7);
    position: fixed;
    z-index: 1;
    top:0;
}
</style>
<script type="text/javascript">
$("#sidebar_overlay").hide();   
    button = $("#header .navbar-nav button");
    $("#header .navbar-nav button").click(function(){
        setTimeout(function() {
            nav = $("#nav-drawer").attr('aria-hidden');
            if(nav == "false") {
                $("#sidebar_overlay").show();
            } else {
                setTimeout(function(){$("#sidebar_overlay").delay(100).hide();}, 150);
            }
        }, 200);

    });
    $("#sidebar_overlay").click(function(){

        if (button.hasClass('is-active')) {
            button.removeClass('is-active');
        }
        $("#nav-drawer").addClass('closed');
        button.attr('aria-expanded', 'false');
        setTimeout(function(){$("#sidebar_overlay").hide();}, 150);
    });
    $(".enlight-frontpage").find('br').hide();
    $(".enlight-frontpage").find('span.skip-block-to').each(function() {
        data = $(this).html();
        if(data.length == "") {
            $(this).hide();
        }
    })
</script>
</body>
</html>
