<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @package    theme_enlight
 * @copyright  2015 onwards LMSACE Dev Team (http://www.lmsace.com)
 * @authors    LMSACE Dev Team
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
$footerb1 = theme_enlight_get_setting('footerb1_status');
$footerb2 = theme_enlight_get_setting('footerb2_status');
$footerb3 = theme_enlight_get_setting('footerb3_status');
$footerb4 = theme_enlight_get_setting('footerb4_status');
$totalEnable = $footerb1 + $footerb2 + $footerb3 + $footerb4;
$footermain = 1;
switch($totalEnable) {
    case 4 :
        $colClass = 'col-md-3';
    break;

    case 3:
        $colClass = 'col-md-4';
    break;

    case 2:
        $colClass = 'col-md-6';
    break;

    case 1:
        $colClass = 'col-md-12';
    break;

    case 0:
        $footermain = 0;
        $colClass = "col-md-0";
    break;

    default:
        $colClass = 'col-md-3';
}



$copyright = theme_enlight_get_setting('copyright');
$copyright = theme_enlight_lang($copyright);
$fb1title = theme_enlight_get_setting('footerbtitle1', 'format_html');
$fb1title = theme_enlight_lang($fb1title);
$fb2title = theme_enlight_get_setting('footerbtitle2', 'format_text');
$fb2title = theme_enlight_lang($fb2title);
$fb3title = theme_enlight_get_setting('footerbtitle3', 'format_text');
$fb3title = theme_enlight_lang($fb3title);
$fb4title = theme_enlight_get_setting('footerbtitle4', 'format_text');
$fb4title = theme_enlight_lang($fb4title);
$footerblink1 = theme_enlight_get_setting('footerdesc1');
$footerblink1 = theme_enlight_lang($footerblink1);
$backToTop_status = theme_enlight_get_setting('backToTop_status');
$social_links = theme_enlight_social_links();
$footerblink3 = theme_enlight_generate_links('footerblink3');
$footerblink2 = theme_enlight_generate_links('footerblink2');
$footerb4Icon_class = theme_enlight_footer_address('true');
$footericonclass = ($footerb4Icon_class == "true") ? "footer-small-socials" : "";
$footerAddress = theme_enlight_footer_address();

$templatecontext = [

          'output' => $OUTPUT,
       "copyright" => $copyright,
        "fb1title" => $fb1title,
        "fb2title" => $fb2title,
        "fb3title" => $fb3title,
        "fb4title" => $fb4title,
    "social_links" => $social_links,
    "footerblink3" => $footerblink3,
    "footerblink2" => $footerblink2,
    "footerblink1" => $footerblink1,
        "footerb1" => $footerb1,
        "footerb2" => $footerb2,
        "footerb3" => $footerb3,
        "footerb4" => $footerb4,
        "colClass" => $colClass,
      "footermain" => $footermain,
   "footerAddress" => $footerAddress,
 'footericonclass' => $footericonclass,
       "backToTop" => $backToTop_status

];


echo $OUTPUT->render_from_template('theme_enlight/footer', $templatecontext);

?>

