<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @package    theme_enlight
 * @copyright  2015 onwards LMSACE Dev Team (http://www.lmsace.com)
 * @authors    LMSACE Dev Team
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

global $CFG, $PAGE;
user_preference_allow_ajax_update('drawer-open-nav', PARAM_ALPHA);
require_once($CFG->libdir . '/behat/lib.php');

//if (isset($_GET))

if (isloggedin()) {
  if ($PAGE->pagelayout == "frontpage") {
    $navdraweropen = false;
    
  } else {
    $navdraweropen = (get_user_preferences('drawer-open-nav', 'false') == 'true');
  }
} else {
    $navdraweropen = false;
}

$extraclasses = [];
if ($navdraweropen) {
    $extraclasses[] = 'drawer-open-left';
}

$primarymenu = $OUTPUT->primarymenu();

if ($primarymenu == '') {
    $class = "navbar-toggler hidden-lg-up nocontent-navbar";
} else {
    $class = "navbar-toggler hidden-lg-up";
}

$bodyattributes = $OUTPUT->body_attributes($extraclasses);
$blockshtml = $OUTPUT->blocks('side-pre');
$hasblocks = strpos($blockshtml, 'data-block=') !== false;
$regionmainsettingsmenu = $OUTPUT->region_main_settings_menu();

$surl = new moodle_url('/course/search.php');
$courserenderer = $PAGE->get_renderer('core', 'course');
$tcmenu = $courserenderer->top_course_menu();
$cmenuhide = theme_enlight_get_setting('cmenuhide');

$curl = new moodle_url('/course/index.php');
$logourl = theme_enlight_get_logo_url();
$topmmenu = $tcmenu['topmmenu'];
$topcmenu = $tcmenu['topcmenu'];
$s_home = get_string('home');
$cmenuhide = (!$cmenuhide) ? 0 : 1 ;
$s_courses = get_string('courses');
$theme_loader = get_theme_loader();    
$headerStyle = theme_enlight_header_style();

$templatecontext = [
    'sitename' => format_string($SITE->shortname, true, ['context' => context_course::instance(SITEID), "escape" => false]),
    'output' => $OUTPUT,
    'sidepreblocks' => $blockshtml,
    'hasblocks' => $hasblocks,
    'bodyattributes' => $bodyattributes,
    'navdraweropen' => $navdraweropen,
    'regionmainsettingsmenu' => $regionmainsettingsmenu,
    'hasregionmainsettingsmenu' => !empty($regionmainsettingsmenu),
    "curl" => $curl,
    "logourl" => $logourl,
    "topmmenu" => $topmmenu,
    "topcmenu" => $topcmenu,
    "s_home" => $s_home,
    "cmenuhide" => $cmenuhide,
    "s_courses" => $s_courses,
    "theme_loader" => $theme_loader,
    'headerStyle' => $headerStyle,
    "primaryclass" => $class
    //"primarymenu" => $primarymenu
];

$templatecontext['flatnavigation'] = $PAGE->flatnav;
echo $OUTPUT->render_from_template('theme_enlight/header', $templatecontext);
$flatnavbar = $OUTPUT->render_from_template('theme_boost/nav-drawer', $templatecontext);

?>
<!--E.O.Header-->

