<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @package    theme_enlight
 * @copyright  2015 onwards LMSACE Dev Team (http://www.lmsace.com)
 * @authors    LMSACE Dev Team
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

?>

 <link href="<?php echo theme_enlight_theme_url(); ?>/style/animate.css" rel="stylesheet" media="all">
<script type='text/javascript' src="<?php echo theme_enlight_theme_url(); ?>/javascript/jquery.mobile.customized.min.js"></script>
 <script type="text/javascript" src="<?php echo theme_enlight_theme_url(); ?>/javascript/jquery.easing.1.3.js"></script>
<script type='text/javascript' src='<?php echo theme_enlight_theme_url(); ?>/javascript/camera.js'></script>
 <link rel='stylesheet' id='camera-css'  href='<?php echo theme_enlight_theme_url(); ?>/style/camera.css' type='text/css' media='all'>

<?php

$slideContent = "";
$overlayArr = array();
$positionArr = array();


    function slideshow_general_config(){

        $general = array();

        $general['slideshowStatus'] = theme_enlight_get_setting('slideshowStatus');
        $general['numberofslides'] = theme_enlight_get_setting('numberofslides');
        $autoslideshow = theme_enlight_get_setting('autoslideshow');
        $slideinterval = theme_enlight_get_setting('slideinterval');
        $slideHeight = theme_enlight_get_setting('slideHeight');
        $general['paginationStatus'] = theme_enlight_get_setting('slideshowpagination');

        $slideHeight = intval($slideHeight);
        $general["slideHeight"] = !empty($slideHeight) ? $slideHeight : "550";
        $slideinterval = intval($slideinterval);
        $general['slideinterval'] = empty($slideinterval) ? 3000 : $slideinterval;
        if($autoslideshow == 1) {
            $general["autoslideshow"] = 'true';
        } else {
            $general["autoslideshow"] = 'false';

        }
        switch($general['paginationStatus']) {
            case "NONE":
                $thumbnails = "false";
                $pagination = "false";
            break;
            case "DOTTHUMB":
                $thumbnails = "true";
                $pagination = "true";
                break;
            case "THUMB" :
                $thumbnails = "true";
                $pagination = "false";
                break;
            case "DOT":
                $thumbnails = "false";
                $pagination = "true";
                break;
            default:
                $thumbnails = "true";
                $pagination = "true";
        }

        $general['thumbnails'] = $thumbnails;
        $general['pagination'] = $pagination;

        return $general;

    }

    function slideshow_header($general) {

        $header = "";
        $header .= html_writer::start_tag('div', array('class' => 'homepage-carousel') );
        $header .= html_writer::start_tag('div', array('id' =>'homepage-carousel', 'class' => ' camera_magenta_skin bs-slider ',  'data-interval'=> $general['slideinterval'] ));

        return $header;
    }

    function slideshow_footer($general) {
        $footer = "";
        $footer .= html_writer::end_tag('div');  // Div #homepage-Carousel.
        $footer .= html_writer::end_tag('div');  // Div .homepage-Carousel.
        return $footer;
    }
    function loader_color($general) {
        $loaderStatus = theme_enlight_get_setting('loaderStatus');
        if (isset($loaderStatus) && $loaderStatus == "1") {
            $loaderStatus = "bar";
        } else {
            $loaderStatus = "none";
        }

        $pattern = theme_enlight_get_setting('patternselect');
        if (isset($pattern)) {
            switch ($pattern) {
                case 'default':
                    $loaderBgColor = "#39b3e6";
                    break;
                case '1':
                    $loaderBgColor = "#7abb3b";
                    break;
                case '2':
                    $loaderBgColor = "#8e558e";
                    break;
                case '3':
                    $loaderBgColor = "#e14d43";
                    break;
                case '4':
                    $loaderBgColor = "#523f6d";
                    break;

                default:
                    $loaderBgColor = "#222222";
                    break;
            }
        }
        $headerStyle = theme_enlight_get_setting('headerStyle');
        if($headerStyle == "1") {
            $loaderBgColor = "#222222";
        }

        return array('loaderBgColor' => $loaderBgColor, 'loaderStatus' => $loaderStatus);
    }

    function slideshow_body($general) {
        $sliderLevel = 0;
        if (!empty($general['numberofslides'])) {
            $data = array();
            $overlayArr = array();
            $sliderLevel = 0;
            $data['maincontent']  = "";
            for ($s1 = 1; $s1 <= $general['numberofslides']; $s1++) {
                $status = theme_enlight_get_setting('slide' . $s1 . 'status');
                if ($status == "1") {
                    $slideconfig = slideshow_slide_settings($general, $s1);
                    if (!empty($slideconfig['slideimg'])) {

                        $overlayArr[$s1-1] = $slideconfig['overlayArr'];
                        $data['maincontent'] .= slideshow_maincontent($slideconfig, $general);
                        $sliderLevel++;
                    }
                }
            }
        }
        $data['sliderLevel'] = $sliderLevel;
        $data['overlay'] = array('overlayArr' => $overlayArr);
        return $data;
    }

    function slideshow_slide_settings($general = array(), $s1 = "") {
        if (!empty($s1) && !empty($general)) {
            $overlayArr = array();

            $overlayClass = "";
            $slide['slideStatus'] = theme_enlight_get_setting('slide' . $s1 . 'status');
            $slide['slideurl1'] = theme_enlight_get_setting('slide' . $s1 . 'url1');
            $slide['slideurl2'] = theme_enlight_get_setting('slide' . $s1 . 'url2');

            $slide['slideimg'] = theme_enlight_render_slideimg($s1, 'slide' . $s1 . 'image');
            $slide['contentPosition'] = theme_enlight_get_setting('slide'. $s1 .'contentPosition');
            $contentAnimation = theme_enlight_get_setting('slide'. $s1 .'contentAnimation');
            $urlTarget1 = theme_enlight_get_setting('slide'. $s1 .'urltarget1');
            $urlTarget2 = theme_enlight_get_setting('slide'. $s1 .'urltarget2');
            $slide['contentStyle'] = theme_enlight_get_setting('slide'. $s1 . 'contentStyle');

            $slide['slideEffect'] = theme_enlight_get_setting('slide'. $s1 .'effect');

            $cont_width = theme_enlight_get_setting('slide'.$s1.'contFullwidth');


            $slidedesc = theme_enlight_get_setting('slide' . $s1 . 'desc', 'format_html');
            $slideurltext1 = theme_enlight_get_setting('slide' . $s1 . 'urltext1');
            $slideurltext2 = theme_enlight_get_setting('slide' . $s1 . 'urltext2');

            $slidecaption = theme_enlight_get_setting('slide' . $s1 . 'caption', true);
            $slide['slidecaption'] = theme_enlight_lang($slidecaption);
            $slide['slideurltext1'] = theme_enlight_lang($slideurltext1);
            $slide['slideurltext2'] = theme_enlight_lang($slideurltext2);

            $slide['slidedesc'] = theme_enlight_lang($slidedesc);
            $s2 = (int) $s1 - 1;
            if($cont_width == "auto") {
                $cont_width = "auto";
            } else {
                $cont_width = intval($cont_width);
                if ($cont_width > '100' ) {
                    $cont_width = '100%';
                } else if($cont_width <= 0) {
                    $cont_width = "auto";
                } else {
                    $cont_width = $cont_width.'%';
                }
            }
            $slide['cont_width'] = $cont_width;


            $slide['contentAnimation'] = htmlspecialchars($contentAnimation);

            if ($slide['contentAnimation'] != "NONE") {
                $slide['contentAclass'] = "animated ". $slide['contentAnimation'];
            } else {
                $slide['contentAclass'] = "none";
            }


            if($urlTarget1 == 1) {
                $slide['btntarget1'] = "_blank";
            } else {
                $slide['btntarget1'] = "_self";
            }
            if($urlTarget2 == 1) {
                $slide['btntarget2'] = "_blank";
            } else {
                $slide['btntarget2'] = "_self";
            }
            if (!empty($slide['contentPosition'])){
                $slide['contentClass'] = 'content-'.$slide['contentPosition'];
            } else{
                $slide['contentClass'] = "content-centerRight";
            }

            if ($s2 == "") {
                $s2 = 0;
            }

            if ($slide['contentStyle'] == '2' ) {
                $slide['overlayClass'] = "content_overlayer";
                $slide['overlayArr'] = "false";
            } else if ($slide['contentStyle'] == '4') {
                $slide['overlayArr'] = "true";
                $slide['overlayClass'] = "slide_overlay";
            } else {
                $slide['overlayClass'] = "";
                $slide['overlayArr'] = "false";
            }

            $slide['dataUrl'] = "";
            if (!empty($slide['slideurl1']) && empty($slide['slideurltext1'])) {
                $slide['dataUrl'] = $slide['slideurl1'];
            }
            if (empty($data['dataUrl'])) {
                if (!empty($slide['slideurl2']) && empty($slide['slideurltext2'])) {
                    $slide['dataUrl'] = $slide['slideurl2'];
                }
            }
        }

        return $slide;
    }

    function slideshow_maincontent($slide, $general) {
        $slideContent = '';
        $slideContent .= html_writer::start_tag('div', array('class' => 'carousel-item', 'data-thumb' => $slide['slideimg'] ,'data-src' => $slide['slideimg'], 'data-fx' => $slide['slideEffect'], 'data-link' => $slide['dataUrl'] ) );

            if( !empty($slide['slidecaption']) || !empty($slide['slidedesc']) || !empty($slide['slideurltext1']) || !empty($slide['slideurltext2']) || !empty($slide['slideurl1']) || !empty($slide['slideurl2'])  ) {

                $slideContent .= slideshow_textContent($slide, $general);

            }
            $slideContent .= html_writer::end_tag('div');  // Div Carousel-item, End Of Wraper.

        return $slideContent;
    }

    function slideshow_textContent($slide, $general) {

        $slideContent = $title2 = '';
        $contentStyle = $slide['contentStyle'];
        switch ($slide['contentStyle']) {
            case 1:
                $contentStyleClass = "text-item-content"; // theme color title contents with dbl btn
                break;
            case 2:
                $contentStyleClass = "content_overlayer";
                break;
            case 3:
                $contentStyleClass = "double-heading-content"; // Double heading
                break;
            case 4:
                $contentStyleClass = "slide_overlay";
                break;
            default:
                $contentStyleClass = "content_overlayer";
        }
        $textContent_class = "slide-text animated fadeIn ";
        $textContent_class .= $slide['contentClass'] ." ";
        $textContent_class .= $contentStyleClass;

        $slideContent .= html_writer::start_tag('div', array('class' => $textContent_class, 'style' => 'width:'.$slide['cont_width'].';'));

        if ($contentStyle == 3) {
            $title = explode('||', $slide['slidecaption']);
            $title2 = isset($title[1]) ? $title[1] : "";
            $slide['slidecaption'] = isset($title[0]) ? $title[0] : $slide['caption'];
            $slideContent .= html_writer::start_tag('div', array('class' => 'heading-content '));
        }

        if ($contentStyle == 3 ) {

            if (!empty($title2)) {
            $slideContent .= html_writer::tag('h1', $slide['slidecaption'], array('class' =>"" ,'data-animation' => $slide['contentAclass']));
            $slideContent .= html_writer::tag('h2', $title2, array('class' => "",'data-animation' =>  $slide['contentAclass']));
             $slideContent .= html_writer::tag('p', $slide['slidedesc'], array('class' => "",'data-animation' =>  $slide['contentAclass']));
            } else {
                 $slideContent .= html_writer::tag('h1', $slide['slidecaption'], array('class' =>"" ,'data-animation' =>  $slide['contentAclass']));
                 $slideContent .= html_writer::tag('p', $slide['slidedesc'], array('class' => "",'data-animation' =>  $slide['contentAclass']));
            }

        } else {
            $slideContent .= html_writer::tag('h1', $slide['slidecaption'], array('class' => $slide['contentAclass'],'data-animation' => 'animated '. $slide['contentAnimation']));
             $slideContent .= html_writer::tag('p', $slide['slidedesc'], array('class' => $slide['contentAclass'],'data-animation' => 'animated '. $slide['contentAnimation']));
        }



        if ($contentStyle == 3) {
            $slideContent .= html_writer::end_tag('div'); // .heading-content.
            $slideContent .= html_writer::start_tag('div', array('class' => 'link-button'));
        }

        if (!empty($slide['slideurl1']) && !empty($slide['slideurltext1'])) {
            $slideContent .= html_writer::link($slide['slideurl1'], $slide['slideurltext1'], array('target' => $slide['btntarget1'], 'class' => 'btn btn-primary '.$slide['contentAclass'], 'data-animation' => 'animated '.$slide['contentAnimation']) );
        }


        if (!empty($slide['slideurltext2'])) {
            $slideContent .= html_writer::link($slide['slideurl2'], $slide['slideurltext2'], array('target' => $slide['btntarget2'], 'class' => 'btn btn-primary '.$slide['contentAclass'], 'data-animation' => 'animated '.$slide['contentAnimation']) );
        }

        if ($contentStyle == 3) {
            $slideContent .= html_writer::end_tag('div'); // .heading-content.
        }


        $slideContent .= html_writer::end_tag('div');  // Div Slide-text.

        return $slideContent;
    }


$general = slideshow_general_config();
if ($general['slideshowStatus'] != 0) {

    global $CFG;

    if ($general['numberofslides'] && !empty($general['numberofslides']) && $general['numberofslides'] >= 1) {

        $header = slideshow_header($general);
        $footer = slideshow_footer($general);
        $data = slideshow_body($general);
        $loader = loader_color($general);
        if (!empty($data['maincontent'])) {
        $slider = $header.$data['maincontent'].$footer;
        /*=============== Slider Contents are displayed here ==============*/
        echo $slider; // Full Slider Contents are printed here.
        }
        if (isset($data['sliderLevel']) && $data['sliderLevel'] <= 1) {
            $general['autoslideshow'] = "false";
            $navigation = "false";
        } else {
            $navigation = "true";
        }
        $array = $data['overlay'];
        $overlayArr = json_encode($array['overlayArr']);  // Json Encode Overlay Contain Images Array.


        if (isset($data['maincontent']) && !empty($data['maincontent'])) {
?>
    <script type="text/javascript" id="camerajs">
    (function($) {
        var interval = "<?php echo $general['slideinterval']; ?>";
        var autoplay = <?php echo $general['autoslideshow'];?>;
        var slideHeight = "<?php echo $general['slideHeight'];?>";
        var thumbnails = <?php echo $general['thumbnails'];?>;
        var pagination = <?php echo $general['pagination'];?>;
        var json = <?php echo $overlayArr;?>;
        var imagePath = <?php echo "'$CFG->wwwroot/theme/enlight/images/'"; ?>;
        var loaderBgColor = "<?php echo $loader['loaderBgColor'];?>";
        var loaderStatus = "<?php echo $loader['loaderStatus'];?>";
        var navigation = <?php echo $navigation;?>;

        // $e = jQuery.noConflict(true);


        $(document).ready(function(){

            var wi = $(window).width();
            if (slideHeight >= wi || slideHeight == "") {
                slideHeight = '550';
            }
            var val = ( parseInt(slideHeight) / parseInt(wi) ) * parseInt(100);
            heightval = val + '%';


            $('#homepage-carousel').camera({
                height: heightval,
                pagination: pagination,
                thumbnails: thumbnails,
                time: interval,
                loaderColor: '#eeeeee',
                loaderBgColor: loaderBgColor, //'#222222',
                loaderOpacity: 0.6, // .8
                loader: loaderStatus,
                autoAdvance: autoplay,
                navigation: navigation,
                mobileAutoAdvance: true,
                mobileNavHover: false,
                imagePath: imagePath,
                overlayer: false,
                loaderOpacity:0.7,
                rows: 4,
                slicedCols: 7,
                slicedRows: 5,
                transPeriod: 1000,
                barPosition: 'top',
                easing: 'easeInOutExpo',
                onEndTransition: function() {
                   $this = $('.camera_target_content .cameracurrent');
                    animation();
                    $('.slide-text').show();
                },
                onLoaded: function() {

                    addOverlay();

                }
            });
            $("#homepage-carousel").cameraPause();
            $(window).on("load", function(){
                if (autoplay == true) {
                    $("#homepage-carousel").cameraResume();
                }
                if ($("#homepage-carousel").width() <= 800) {
                    $("#homepage-carousel").cameraResume();
                }
            });

            function animation() {
                $this = $('.camera_target_content .cameracurrent')
                $content = $this.find('.heading-content [data-animation ^= "animated"]');
                index = 0;
                if ($content != "undefined" && $content.length != ""){
                    $content.css({'opacity': 0});
                    $time = setInterval(function () {
                        $this = $content;
                        da = $content.eq(index);
                        ani = da.attr('data-animation');
                        da.addClass(ani);
                        da.css({'opacity': 1});
                        index++;
                        if (index == $this.length) {
                            clearInterval($time);
                        }
                        doAnimations(da);
                    }, 400);

                }
            }


            function doAnimations(elems) {
              var animEndEv = 'webkitAnimationEnd animationend';
              elems.each(function () {
                var $this = $(this),
                    $animationType = $this.data('animation');
                $this.addClass($animationType).one(animEndEv, function () {
                  $this.removeClass($animationType);
                });
              });
            }

            function addOverlay() {
                var json = <?php echo $overlayArr;?>;
                $.each(json, function(n, value) {
                    if (value == "true") {
                        cmr = $(".camera_target .cameraCont").find('.cameraSlide_'+n);
                        cmr.find('.camerarelative').addClass('content_overlayer');
                    }
                })
            }


        });
    })(jQuery);

    </script>


<?php
        } // Check maincontents are not empty.
    } // Check number of slides is more than one.
} // Check the slideshow is diable or enable.


