<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * The one column layout.
 *
 * @package    theme_enlight
 * @copyright  2015 onwards LMSACE Dev Team (http://www.lmsace.com)
 * @authors    LMSACE Dev Team
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

global $CFG, $PAGE;

$loginpageType = (isset($PAGE->theme->settings->loginpageType) ) ? $PAGE->theme->settings->loginpageType : "1";
if ($loginpageType == "0") :
echo "<style>#header .navbar-nav button.btn{ display:none;}</style>";
$bodyattributes = $OUTPUT->body_attributes();
$blockshtml = $OUTPUT->blocks('side-pre');
$hasblocks = strpos($blockshtml, 'data-block=') !== false;
$regionmainsettingsmenu = $OUTPUT->region_main_settings_menu();

$surl = new moodle_url('/course/search.php');
$courserenderer = $PAGE->get_renderer('core', 'course');
$tcmenu = $courserenderer->top_course_menu();
$cmenuhide = theme_enlight_get_setting('cmenuhide');
//$primarymenu = theme_enlight_primary_menuitems();

$curl = new moodle_url('/course/index.php');
$logourl = theme_enlight_get_logo_url();
$topmmenu = $tcmenu['topmmenu'];
$topcmenu = $tcmenu['topcmenu'];
$s_home = get_string('home');
$cmenuhide = (!$cmenuhide) ? 0 : 1 ;
$s_courses = get_string('courses');


$templatecontext = [
    'sitename' => format_string($SITE->shortname, true, ['context' => context_course::instance(SITEID), "escape" => false]),
    'output' => $OUTPUT,
   
    "curl" => $curl,
    "logourl" => $logourl,
    "topmmenu" => $topmmenu,
    "topcmenu" => $topcmenu,
    "s_home" => $s_home,
    "cmenuhide" => $cmenuhide,
    "s_courses" => $s_courses,
    //"primarymenu" => $primarymenu
];


echo $OUTPUT->render_from_template('theme_enlight/login', $templatecontext);


else:

$html = theme_enlight_get_html_for_settings($OUTPUT, $PAGE);
if (!isset($frm) or !is_object($frm)) {
    $frm = new stdClass();
}

$authsequence = get_enabled_auth_plugins(true);
if (empty($frm->username) && $authsequence[0] != 'shibboleth') {  // See bug 5184
    if (!empty($_GET["username"])) {
        $frm->username = clean_param($_GET["username"], PARAM_RAW); // we do not want data from _POST here
    } else {

            $frm->username = get_moodle_cookie();

    }

    $frm->password = "";
}

if (isloggedin() && !isguestuser()) {
    redirect ($CFG->wwwroot);
}
if (empty($CFG->authloginviaemail)) {
    $strusername = get_string('username');
} else {
    $strusername = get_string('usernameemail');
}
echo $OUTPUT->doctype() ?>
<html <?php echo $OUTPUT->htmlattributes(); ?>>
<head>
    <title><?php echo $OUTPUT->page_title(); ?></title>
    <link rel="shortcut icon" href="<?php echo $OUTPUT->favicon(); ?>" />
    <?php echo $OUTPUT->standard_head_html() ?>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style type="text/css">
	#site-footer { padding: 0px !important; }
	</style>
</head>

<body <?php echo $OUTPUT->body_attributes(); ?>>

<?php echo $OUTPUT->standard_top_of_body_html() ?>

<?php  require_once(dirname(__FILE__) . '/includes/header.php');  ?>

<?php 
if ($PAGE->pagetype == "login-index") {
    $hide = "";
    $hide2 = "display:none";
} else {
    $hide = "display:none";
    $hide2 = "";
}
echo "<div style='".$hide2."'>".$OUTPUT->main_content()."</div>";  ?>
<style>#header .navbar-nav button.btn{ display:none;}</style>

<div id="custom-page" class="custom-login-page" style="<?php echo $hide;?>">
	<div class="container">

    	<div class="form-box">
        	<div class="fbox-head">
            	<h2 style="font-size: 22px;">Primeiro acesso na Escola<br>Governar? <a style="color: #fff;" href='/escolagovernar/login/signup.php'>Clique aqui</a>. Caso já tenha uma conta, faça seu login</h2>
            </div>


            <div class="fbox-body">
            <form action="<?php echo $CFG->httpswwwroot; ?>/login/index.php" method="post" id="login1" >
             <div class="alert alert-error" id="lemsg" style="display:none;">
                  &nbsp;
                </div>

            	<div class="form-fields">
                	<label><?php echo($strusername) ?></label>
                    <input type="text" name="username"  value="<?php p($frm->username) ?>" />
                </div>
            	<div class="form-fields">
                	<label><?php print_string("password") ?></label>
                    <input type="password" name="password" value="" />
                </div>
				<div class="support-field">
                    <label class="checkbox">
                       <input type="checkbox" name="rememberusername" value="1"
                        <?php if ($frm->username) {echo 'checked="checked"';} ?> />
                        <?php print_string('rememberusername', 'admin') ?>
                    </label>
                    <div class="form-action">
                    <input type="submit" id="loginbtn1" value="<?php print_string("login") ?>" />
                </div>
                    <?php
                    if ($CFG->registerauth == 'email') {
                        $signup = get_string('startsignup');
                       // echo "<p><a href='".new moodle_url('/login/signup.php')."'>Se você ainda não possui cadastro, basta clicar  aqui e fazer o seu agora mesmo</a></p><br>";

                    } 
                    ?>
                    <p><a href="<?php  echo new moodle_url("/login/forgot_password.php"); ?>">
                    <?php print_string("forgotten") ?></a></p>
                </div>
                
                </form>
<?php if ($CFG->guestloginbutton and !isguestuser()) {  ?>
                <form action="index.php" method="post" id="guestlogin">
                  <div class="form-action">
				    <input type="hidden" name="username" value="guest" />
                    <input type="hidden" name="password" value="guest" />
                    <input type="submit" value="<?php print_string("loginguest") ?>" />
                 </div>
               </form>
<?php
}

?>
            </div>

        </div>

    </div>

    <?php //echo !empty($flatnavbar) ? $flatnavbar : ""; ?>
</div>
<?php require_once(dirname(__FILE__) . '/includes/footer.php'); ?>

<!--E.O.custom-page-->
<!-- <script type="text/javascript" src="<?php echo $CFG->wwwroot.'/theme/enlight/javascript/theme.js'?>"></script> -->
<script>
$(function(){
    var e1 = $("#loginerrormessage").text();
    if(e1.length>0)
    {
        $("#lemsg").html(e1);
        $("#lemsg").show();
    }
    $("#loginbtn").click(function(){
        var uname = $("#login1 input[name=username]").val();
        $("#login input[name=username]").val(uname);

        var pwd = $("#login1 input[name=password]").val();
        $("#login input[name=password]").val(pwd);
        $("#login").submit();
    });
    
});
</script>


</body>
</html>
<?php endif; ?>
