<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @package    theme_enlight
 * @copyright  2015 onwards LMSACE Dev Team (http://www.lmsace.com)
 * @authors    LMSACE Dev Team
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();
require_once($CFG->dirroot . "/course/renderer.php");

/**
 * Theme Enlight course renderer class inherit from core course renderer class.
 */
class theme_enlight_core_course_renderer extends core_course_renderer {


    /**
     * Popular Course block for frontpage contains the list of courses.
     * @return string
     */
    public function popular_courses() {

        global $CFG, $OUTPUT, $PAGE;
        $popularCourse_status = theme_enlight_get_setting('popularCourse_status');
        $popularCourse_type = theme_enlight_get_setting('popularCourse_type');
        $popularCourse_id = theme_enlight_get_setting('popularCourse_id');
        $headingStatus = "";
        if ($popularCourse_status != 1) {
            return '';
        }
        $popularcontent = '';
        if ($popularCourse_type == 1 ) {
            $pcourses = $this->course_insights_home(1);
            if (empty($pcourses)) {
                return false;
            }
            $astu = array();
            foreach ($pcourses as $pcourse) {
                $rcourseids[] = $pcourse['cid'];
                $astu[$pcourse['cid']] = $pcourse['students'];
            }
        } else if ($popularCourse_type == 2 ) {
            $pcourses = explode(',', $popularCourse_id);
            $rcourseids = array_filter($pcourses, 'strlen');
            $rcourseids = $this->check_course_id($rcourseids);
        } else {
            $rcourseids = "";
        }
        if (empty($rcourseids)) {
            return '';
        }
        $pcourseids = array_chunk($rcourseids, 6);
        $totalpcourse = count($pcourseids);
        $popularheader = '<div class="frontpage-custom-blocks popular-courses-block" id="Popular-Courses">
							  <div class="bgtrans-overlay"><div>&nbsp;</div></div>
							 <div class="container">
							  <div class="titlebar">
							     <h2 class="pull-left"><i class="fa fa-play-circle-o"></i>'
             .get_string('popularcourses', 'theme_enlight').'</a></h2>
							   <div class="pagenav slider-nav pull-right">
							     <button class="slick-prev nav-item previous" type="button">
								 </button>
								 <button class="slick-next nav-item next" type="button">
								 </button>
							    <div class="clearfix"></div>
							   </div>
							   <div class="clearfix"></div>
							  </div>
							  <div class="row">
							<div class="popular_courses col-md-12 " data-crow="'.$totalpcourse.'">';

        $popularfooter = '</div>
							</div>
							 </div>
							</div>';

        if (!empty($pcourseids)) {
            foreach ($pcourseids as $courseids) {
                $rowcontent = '<div>';
                $cnt = 0;
                foreach ($courseids as $courseid) {
                    if (!empty($courseid)) {
                    $cnt++;
                    //if(get_course($courseid)){
                        $course = $this->get_course($courseid);
                        if (!empty($course)) {
                        $headingStatus = true;
                        $noimgurl = $OUTPUT->image_url('no-image', 'theme');

                        $courseurl = new moodle_url('/course/view.php', array('id' => $courseid ));
                        if ($course instanceof stdClass) {
                            require_once($CFG->libdir. '/coursecatlib.php');
                            $course = new course_in_list($course);
                        }
                        $imgurl = '';
                        $summary = theme_enlight_strip_html_tags($course->summary);
                        $summary = theme_enlight_course_trim_char($summary, 75);
                        $context = context_course::instance($course->id);
                        $nostudents = count_role_users(5, $context);
                        foreach ($course->get_course_overviewfiles() as $file) {
                            $isimage = $file->is_valid_image();
                            $imgurl = file_encode_url("$CFG->wwwroot/pluginfile.php",
                                '/'. $file->get_contextid(). '/'. $file->get_component(). '/'.
                                $file->get_filearea(). $file->get_filepath(). $file->get_filename(), !$isimage);
                            if (!$isimage) {
                                $imgurl = $noimgurl;
                            }
                        }
                        if (empty($imgurl)) {
                            $imgurl = $noimgurl;
                        }
                        $coursehtml = ' <div class="col-md-2">
    								   <div class="wrapper">
    										<div class="thumb"><a href="'.$courseurl.'"><img src="'.
                            $imgurl.'" width="180" height="180" alt="'.$course->fullname.'"></a></div>
    									  <div class="info">
    										<h6 class="title-text"><a href="'.$courseurl.'">'.$course->fullname.'</a></h6>
    										
    									  </div>
    									</div>
    								  </div>';

                        $rowcontent .= $coursehtml;
                        }
                    }
                }
                $rowcontent .= '</div>';
                $popularcontent .= $rowcontent;
            }
        }
        if (empty($courseids) || $headingStatus != true || $popularcontent == "" && $popularCourse_type == 2) {
            return "";
        }
        $popularcourses = $popularheader.$popularcontent.$popularfooter;
        /* Display the popular courses in Home page */
        return $popularcourses;

    }

    /**
     * Get the visible and parent categories from categories list.
     * @return array
     */
    public function get_categories() {
        global $DB;
        $categories = array();
        $results = $DB->get_records('course_categories', array('parent'  => '0', 'visible' => '1', 'depth' => '1'));
        if(!empty($results)) {
            foreach ($results as $value) {
                $categories[$value->id] = $value->name;
            }
        }
        return $categories;
    }

    /**
     * Renderer function for override the frontpage categories list
     * @return string(html)
     */
    public function frontpage_categories_list() {
       
           $catheader .= '<div class="frontpage-custom-blocks categories-block" id="Listcategories"><div class="container"><div class="titlebar"><h2>Acesse Também</h2>
                            <div class="clearfix"></div>
                        </div>
        <div class="row">
        <div class="col-md-12 list_categories slick-initialized slick-slider" data-crow="2"><div aria-live="polite" class="slick-list draggable" tabindex="0">
        <div class="slick-track" style="opacity: 1; width: 4960px; transform: translate3d(-1240px, 0px, 0px);"><div class="slider-row slick-slide slick-cloned" data-slick-index="-1" aria-hidden="true" style="width: 1240px;"><div class="col-md-3">
                                   
                                
                                </div></div><div class="slider-row slick-slide slick-active" data-slick-index="0" aria-hidden="false" style="width: 1240px;"><div class="col-md-3">
                                    <div class="wrapper">
                                        <div class="thumb"><a href="http://servicos.sead.am.gov.br/escolagovernar/#">
                                        
                                        <img src="http://servicos.sead.am.gov.br/escolagovernar/bloco-01.jpg" width="180" height="180" alt="Planejamento"></a></div>

                                    </div>
                                </div><div class="col-md-3">
                                    <div class="wrapper">
                                        <div class="thumb"><a href="http://servicos.sead.am.gov.br/escolagovernar/#">

                                        <img src="http://servicos.sead.am.gov.br/escolagovernar/bloco-02.jpg" width="180" height="180" alt="Programa Valorização do Servidor"></a></div>

                                   
                                    </div>
                                </div><div class="col-md-3">
                                    <div class="wrapper">
                                        <div class="thumb"><a href="http://servicos.sead.am.gov.br/escolagovernar/#">


                                        <img src="http://servicos.sead.am.gov.br/escolagovernar/bloco-03.jpg" width="180" height="180" alt="Biblioteca Virtual"></a></div>

                                      
                                    </div>
                                </div><div class="col-md-3">
                                    <div class="wrapper">
                                        <div class="thumb"><a href="http://servicos.sead.am.gov.br/escolagovernar/#">


                                        <img src="http://servicos.sead.am.gov.br/escolagovernar/bloco-04.jpg" width="180" height="180" alt="Relação de Agentes"></a></div>

                                      
                                    </div>
                                </div></div>
                                </div></div></div></div></div></div> </div></div></div>';
       
        
        echo $catheader;
    }

    public function course_insights_home ($f = 0) {
        $courses = 0;
        $teachers = 0;
        $students = 0;
        $acourses = array();
        $astu = array();
        $atea = array();
        /* Get all courses */
        if ($ccc = get_courses('all', 'c.sortorder ASC', 'c.id,c.shortname,c.visible')) {
            foreach ($ccc as $cc) {
                if ($cc->visible == "0" || $cc->id == "1") {
                    continue;
                }
                $courses++;

                $context = context_course::instance($cc->id);

                /* count no of teachers */
                $noteachers = count_role_users(3, $context);
                $teachers = $teachers + $noteachers;
                /* count no of students */
                $nostudents = count_role_users(5, $context);
                $students = $students + $nostudents;
                $acourses[] = array('cid' => $cc->id, 'students' => $nostudents,
                     'teachers' => $noteachers
                );
                $astu[] = $nostudents;
                $atea[] = $noteachers;
            }
        }
        if ($f == "1") {
            array_multisort($astu, SORT_DESC, $atea, SORT_DESC, $acourses);
            $acourses = array_slice($acourses, 0, 24, true);
            return $acourses;
        }
        return compact('courses', 'teachers', 'students');
    }

    /**
     * Select the category page layout.
     * @param  $category
     * @return string $ouput
     */
    public function course_category($category) {
        global $CFG;
        $clayout = get_config('theme_enlight', 'courselayout');
        if ($clayout == "layout1") {
            $cpage = $this->custom_course_page($category);
            return $cpage;
        } else if ($clayout == "layout2") {
            $cpage = $this->custom_course_page2($category);
            return $cpage;
        } else {
            return parent::course_category($category);
        }

    }

    /**
     * Category custom page layout 2
     * @param array $category
     * @return
     */
    private function custom_course_page2($category) {
        global $OUTPUT, $PAGE, $CFG, $DB, $USER;
        require_once($CFG->libdir. '/coursecatlib.php');
        $output = '';
        $page = optional_param('page', '0', PARAM_INT);
        $categoryid = optional_param('categoryid', null, PARAM_INT);
        $ctype = optional_param('ctype', null, PARAM_TEXT);
        // Course page title.
        require_once($CFG->libdir. '/coursecatlib.php');
        $coursecat = coursecat::get(is_object($category) ? $category->id : $category);
        $site = get_site();
        if (!$coursecat->id) {
            if (coursecat::count_all() == 1) {
                // There exists only one category in the system, do not display link to it.
                $coursecat = coursecat::get_default();
                $strfulllistofcourses = get_string('fulllistofcourses');
                $this->page->set_title("$site->shortname: $strfulllistofcourses");
            } else {
                $strcategories = get_string('categories');
                $this->page->set_title("$site->shortname: $strcategories");
            }
        } else {
            $this->page->set_title("$site->shortname: ". $coursecat->get_formatted_name());
        }
        // Course page title.
        $displaylist = coursecat::make_categories_list();
        $seg = $page;
        $perpage = '8';
        $baseurl = new moodle_url('/course/index.php', array("categoryid" => $categoryid,
             "ctype" => $ctype)
        );

        $offset  = $seg * $perpage;

        $catid = (empty($categoryid)) ? 'all' : $categoryid;

        if (empty($ctype) || $ctype == "asc") {
            $sortstr = 'c.sortorder ASC';
        } else {
            $sortstr = 'c.sortorder DESC';
        }

        $mycourses = theme_enlight_get_courses_page1($catid, $sortstr, 'c.id,
c.category,c.shortname,c.fullname,c.visible,c.sortorder,c.idnumber ,c.startdate,c.groupmode,c.groupmodeforce,c.cacherev',
         $totalcount, $offset, $perpage);

        $paging = $OUTPUT->paging_bar($totalcount, $page, $perpage, $baseurl);
        $topmnu = $this->category_menu2($totalcount);

        $header = '<div id="custom-page">
           	<div class="container">
        <div class="site-custom-blocks custom-listing-01">';

        $menustr = '<div class="titlebar">
                <h3>'.get_string('courses').'</h3>
				'.$topmnu.'
			 </div>';

        $footer = '</div>
				</div>
			</div>';

        $coursestr = $this->display_course2($mycourses);

        $output .= $header.$menustr.$coursestr.$paging.$footer;

        return $output;
    }

    /**
     * Course custom page 2
     * @param array $category
     * @return string
     */
    private function custom_course_page($category) {
        global $CFG;
        require_once($CFG->libdir. '/coursecatlib.php');
        $coursecat = coursecat::get(is_object($category) ? $category->id : $category);
        $site = get_site();
        $categoryid = optional_param('categoryid', 0, PARAM_INT);

        if (!$coursecat->id) {
            if (coursecat::count_all() == 1) {
                // There exists only one category in the system, do not display link to it.
                $coursecat = coursecat::get_default();
                $strfulllistofcourses = get_string('fulllistofcourses');
                $this->page->set_title("$site->shortname: $strfulllistofcourses");
            } else {
                $strcategories = get_string('categories');
                $this->page->set_title("$site->shortname: $strcategories");
            }
        } else {
            $this->page->set_title("$site->shortname: ". $coursecat->get_formatted_name());
        }

        $list = coursecat::make_categories_list();

        if ($coursecat->id) {
            $list = array($coursecat->id => $list[$coursecat->id]);
        }

        $addnew = '';
        $context = get_category_or_system_context($coursecat->id);
        if (has_capability('moodle/course:create', $context)) {
            // Print link to create a new course, for the 1st available category.
            if ($coursecat->id) {
                $url = new moodle_url('/course/edit.php', array('category' => $coursecat->id, 'returnto' => 'category'));
            } else {
                $url = new moodle_url('/course/edit.php', array('category' => $CFG->defaultrequestcategory,
                     'returnto' => 'topcat'));
            }
            $addnew = $this->single_button($url, get_string('addnewcourse'), 'get');
        }

        $output = '';
        $srchurl = new moodle_url('/course/search.php');

        $output .= '<div class="site-custom-search">
              <div class="site-custom-search-wrap">
			   <form action="'.$srchurl.'" method="get">
                <div class="form-fields">
                  <input type="text" value=""  name="search" placeholder="'.get_string("cat-placeholder","theme_enlight").'">
                  <div class="action-btn"><i class="fa fa-search"></i><input type="submit" value="Search"></div>
                </div>
				</form>
              </div>
            </div>';

        foreach ($list as $catid => $catname) {
            if ($categoryid > 0) {
                $output .= $this->load_course_list_all($catid, $catname);
            } else {
                $output .= $this->load_course_list($catid, $catname);
            }
        }

        return $output;

    }
    /**
     * Load all course list under the category.
     * @param integer $catid category id.
     * @param string $catname category name.
     * @return array.
     */
    private function load_course_list_all ($catid, $catname) {
        global $CFG, $OUTPUT;
        $rcourseids = array();
        $categoryid = optional_param('categoryid', 0, PARAM_INT);

        if ($CFG->dbtype == "postgresql"){
             if ($categoryid > 0) {
                $lmstr = 'LIMIT 24 OFFSET 0';
            } else {
                $lmstr = '';
            }
        } else {

            if ($categoryid > 0) {
                $lmstr = 'LIMIT 0, 24';
            } else {
                $lmstr = '';
            }
        }

        if ($ccc = get_courses($catid, 'c.id DESC,c.sortorder ASC '.$lmstr, 'c.id,c.shortname,c.visible')) {
            foreach ($ccc as $cc) {
                if ($cc->visible == "0" || $cc->id == "1") {
                    continue;
                }
                $rcourseids[] = $cc->id;
            }

            if (empty($rcourseids)) {
                return '';
            }

            $lcourseids = array_chunk($rcourseids, 6);
            $totallcourse = count($lcourseids);

            $clstxt = 'list_courses'.$catid;
            $idtxt = 'List-Courses'.$catid;
            $caturl = new moodle_url("/course/index.php", array("categoryid" => $catid));

            $listbtn = '<div class="pagenav slider-nav btnwrap">
<button class="slick-prev nav-item previous" type="button">
<i class="fa fa-chevron-right"></i><i class="fa fa-chevron-left"></i>
</button>
<button class="slick-next nav-item next" type="button">
<i class="fa fa-chevron-right"></i><i class="fa fa-chevron-left"></i>
</button>
</div>';

            $listbtn = ( $totallcourse > 1 ) ? $listbtn : '';

            $listheader = '<div class="site-custom-blocks custom-listing" id="'.$idtxt.'">
			<div class="titlebar">
			  <h3>'.$catname.'</h3>
			  '.$listbtn.'
			  <div class="clearfix"></div>
			</div>
			<div class="'.$clstxt.'">';

            $listfooter = '</div>
						 </div>';

            $listcontent = '';

            if (!empty($lcourseids)) {
                foreach ($lcourseids as $courseids) {
                    $rowcontent = '<div>';
                    $cnt = 0;
                    $innerrow = '<div class="row">';
                    foreach ($courseids as $courseid) {
                        $cnt++;
                        $course = get_course($courseid);
                        $noimgurl = $OUTPUT->image_url('no-image', 'theme');

                        $courseurl = new moodle_url('/course/view.php', array('id' => $courseid ));

                        if ($course instanceof stdClass) {
                            require_once($CFG->libdir. '/coursecatlib.php');
                            $course = new course_in_list($course);
                        }

                        $imgurl = '';

                        $summary = theme_enlight_strip_html_tags($course->summary);
                        $summary = theme_enlight_course_trim_char($summary, 75);

                        $context = context_course::instance($course->id);
                        $nostudents = count_role_users(5, $context);
                        $noteachers = count_role_users(3, $context);

                        foreach ($course->get_course_overviewfiles() as $file) {
                            $isimage = $file->is_valid_image();
                            $imgurl = file_encode_url("$CFG->wwwroot/pluginfile.php",
                                '/'. $file->get_contextid(). '/'. $file->get_component(). '/'.
                                $file->get_filearea(). $file->get_filepath(). $file->get_filename(), !$isimage);

                            if (!$isimage) {
                                $imgurl = $noimgurl;
                            }
                        }

                        if (empty($imgurl)) {
                            $imgurl = $noimgurl;
                        }

                        $stlang = ($nostudents > 1) ? 'students' : 'defaultcoursestudent';
                        $telang = ($noteachers > 1) ? 'teachers' : 'defaultcourseteacher';

                        $coursehtml = '<div class="col-md-4">
						<div class="box">
						  <div class="box-thumb">
							<a href="'.$courseurl.'"><img src="'.$imgurl.'" alt="'.$course->fullname.'"></a>
						  </div>
						  <div class="box-content">
							<h6 class="title-text"><a href="'.$courseurl.'">'.$course->fullname.'</a></h6>
							<hr>
							<div class="stat-info">
							  <span title="'.$noteachers.' '.get_string($telang).'"><i class="fa fa-user"></i>'.$noteachers.'</span>
							  <span title="'.$nostudents.' '.get_string($stlang).'"><i class="fa fa-group"></i>'.$nostudents.'</span>
							  <div class="clearfix"></div>
							</div>
							<hr>
							<div class="more-link"><a href="'.$courseurl.'">'.
                        get_string('knowmore', 'theme_enlight').' <i class="fa fa-arrow-right"></i></a></div>
						  </div>
						</div>
					  </div>';

                        $innerrow .= $coursehtml;
                        if ($cnt > 0 && $cnt % 3 == "0") {
                            $innerrow .= '</div><div class="row">';
                        }
                    }
                    $innerrow .= '</div>';
                    $rowcontent .= $innerrow;
                    $rowcontent .= '</div>';
                    $listcontent .= $rowcontent;
                }
            }

            $slrtl = (right_to_left()) ? ' , '."\n".'rtl: true' : '';

            $scpt = '';

            if (!empty($listbtn) ) {
                $scpt = '<script>
                    $(function(){
                    	$(".'.$clstxt.'").slick({
                    		arrows:true ,
                    		swipe:false,
                    		prevArrow:\'#'.$idtxt.' .pagenav .slick-prev\',
                    		nextArrow: \'#'.$idtxt.' .pagenav .slick-next\' '.$slrtl.'
                    	});
                    });
                    </script>';
            }

            $listcourses = $listheader.$listcontent.$listfooter."<br/>".$scpt;
            return $listcourses;

        } else {
            return '';
        }

    }

    private function load_course_list($catid, $catname) {
        global $CFG, $OUTPUT;
        $rcourseids = array();
        $categoryid = optional_param('categoryid', 0, PARAM_INT);
        if ($CFG->dbtype == "postgresql") {
            if ($categoryid > 0) {
                $lmstr = 'LIMIT 24 OFFSET 0';
            } else {
                $lmstr = '';
            }
        } else{
            if ($categoryid > 0) {
                $lmstr = 'LIMIT 0, 24';
            } else {
                $lmstr = '';
            }
        }


        if ($ccc = get_courses($catid, 'c.id DESC, c.sortorder ASC '.$lmstr, 'c.id,c.shortname,c.visible')) {
            foreach ($ccc as $cc) {
                if ($cc->visible == "0" || $cc->id == "1") {
                    continue;
                }
                $rcourseids[] = $cc->id;
            }

            if (empty($rcourseids)) {
                return '';
            }

            $lcourseids = array_chunk($rcourseids, 3);
            $totallcourse = count($lcourseids);

            $clstxt = 'list_courses'.$catid;
            $idtxt = 'List-Courses'.$catid;
            $caturl = new moodle_url("/course/index.php", array("categoryid" => $catid));

            $listbtn = '<div class="pagenav slider-nav btnwrap">
				<a href="'.$caturl.'">'.get_string('viewall', 'theme_enlight').'</a>
				 <button class="slick-prev nav-item previous" type="button">
				 <i class="fa fa-chevron-right"></i><i class="fa fa-chevron-left"></i></button>
				<button class="slick-next nav-item next" type="button">
				<i class="fa fa-chevron-right"></i><i class="fa fa-chevron-left"></i></button>
			  </div>';

            $listbtn = ( $totallcourse > 1 ) ? $listbtn : '';

            if ($categoryid > 0) {
                $listbtn = '';
            }

            $listheader = '<div class="site-custom-blocks custom-listing" id="'.$idtxt.'">
			<div class="titlebar">
			  <h3>'.$catname.'</h3>
			  '.$listbtn.'
			  <div class="clearfix"></div>
			</div>
			<div class="row '.$clstxt.'">';

            $listfooter = '</div>
						 </div>';

            $listcontent = '';

            if (!empty($lcourseids)) {
                foreach ($lcourseids as $courseids) {
                    $rowcontent = '<div>';
                    $cnt = 0;

                    foreach ($courseids as $courseid) {
                        $cnt++;
                        $course = get_course($courseid);
                        $noimgurl = $OUTPUT->image_url('no-image', 'theme');

                        $courseurl = new moodle_url('/course/view.php', array('id' => $courseid ));

                        if ($course instanceof stdClass) {
                            require_once($CFG->libdir. '/coursecatlib.php');
                            $course = new course_in_list($course);
                        }

                        $imgurl = '';

                        $summary = theme_enlight_strip_html_tags($course->summary);
                        $summary = theme_enlight_course_trim_char($summary, 75);

                        $context = context_course::instance($course->id);
                        $nostudents = count_role_users(5, $context);
                        $noteachers = count_role_users(3, $context);

                        foreach ($course->get_course_overviewfiles() as $file) {
                            $isimage = $file->is_valid_image();
                            $imgurl = file_encode_url("$CFG->wwwroot/pluginfile.php",
                                '/'. $file->get_contextid(). '/'. $file->get_component(). '/'.
                                $file->get_filearea(). $file->get_filepath(). $file->get_filename(), !$isimage);
                            if (!$isimage) {
                                $imgurl = $noimgurl;
                            }
                        }

                        if (empty($imgurl)) {
                            $imgurl = $noimgurl;
                        }
                        $stlang = ($nostudents > 1) ? 'students' : 'defaultcoursestudent';
                        $telang = ($noteachers > 1) ? 'teachers' : 'defaultcourseteacher';

                        $coursehtml = '<div class="col-md-4">
                       <div class="box">
                      <div class="box-thumb">
                        <a href="'.$courseurl.'"><img src="'.$imgurl.'" alt="'.$course->fullname.'"></a>
                      </div>
                      <div class="box-content">
                        <h6 class="title-text"><a href="'.$courseurl.'">'.$course->fullname.'</a></h6>
                        <hr>
                        <div class="stat-info">
                          <span title="'.$noteachers.' '.get_string($telang).'"><i class="fa fa-user"></i>'.$noteachers.'</span>
                          <span title="'.$nostudents.' '.get_string($stlang).'"><i class="fa fa-group"></i>'.$nostudents.'</span>
                          <div class="clearfix"></div>
                        </div>
                        <hr>
                        <div class="more-link"><a href="'.$courseurl.'">'.
                        get_string('knowmore', 'theme_enlight').'<i class="fa fa-arrow-right"></i></a></div>
                      </div>
                    </div>
                  </div>';

                        $rowcontent .= $coursehtml;
                    }
                    $chtmlend = '</div>';

                    $rowcontent .= '</div>';
                    $listcontent .= $rowcontent;
                }
            }

            $slrtl = (right_to_left()) ? ' , '."\n".'rtl: true' : '';

            $scpt = '';

            if (!empty($listbtn) && $categoryid == "0" ) {
                $scpt = '<script>
$(function(){
	$(".'.$clstxt.'").slick({
		arrows:true ,
		swipe:false,
		prevArrow:\'#'.$idtxt.' .pagenav .slick-prev\',
		nextArrow: \'#'.$idtxt.' .pagenav .slick-next\' '.$slrtl.'
	});
});
</script>';

            }

            $listcourses = $listheader.$listcontent.$listfooter."<br/>".$scpt;
            return $listcourses;

        } else {
            return '';
        }

    }

    /**
     * Course list for course menu on header
     * @return type
     */
    public function top_course_menu() {
        global $CFG, $OUTPUT, $DB;
        require_once($CFG->libdir. '/coursecatlib.php');
        $list = coursecat::make_categories_list();
        $mclist = array();
        if ($CFG->dbtype == "postgresql") {
            $sql = "SELECT a.category , a.cnt from (
            SELECT category , count(category) as cnt FROM {course}
            WHERE category != '0' and visible = ?
            group by category
            order by randam()) as a
            order by a.cnt desc ";
        } else {
            $sql = "SELECT a.category , a.cnt from (
            SELECT category , count(category) as cnt FROM {course}
            WHERE category != '0' and visible = ?
            group by category
            order by rand()) as a
            order by a.cnt desc ";
        }
        $params = array('1');
        $result = $DB->get_records_sql($sql, $params, 0, 4);
        if ($result) {
            foreach ($result as $rowcat) {
                $mclist[] = $rowcat->category;
            }
        }
        $rcourseids = array();
        foreach ($mclist as $catid) {
            $cname = coursecat::get($catid, MUST_EXIST, true)->get_formatted_name();
            $menuheader = '<div class="cols">
                              <h6>'.$cname.'</h6>
                           <ul>'."\n";
            $menufooter = '</ul>
            </div>'."\n";
            $href = $CFG->wwwroot.'/course/index.php?categoryid='.$catid;
            $mmenuheader = '<li class="dropdown-submenu">
            <a href="'.$href.'" class="">'.$cname.'</a>
            <ul class="dropdown-menu">';
            $mmenufooter = '</ul>
        </li>';

            $menuitems = '';
            if ($CFG->dbtype == "postgresql") {
                $condition = "c.id DESC,c.sortorder ASC LIMIT 6 OFFSET 0";
            } else {
                $condition = "c.id DESC,c.sortorder ASC LIMIT 0, 6";
            }

            if ($ccc = get_courses($catid, $condition, 'c.id,c.shortname,c.fullname,c.visible')) {
                foreach ($ccc as $cc) {
                    if ($cc->visible == "0" || $cc->id == "1") {
                        continue;
                    }
                    $courseurl = new moodle_url("/course/view.php", array("id" => $cc->id));
                    $menuitems .= '<li><a href="'.$courseurl.'">'.$cc->fullname.'</a></li>'."\n";
                }
                if (!empty($menuitems)) {
                    $rcourseids[$catid] = array("desk" => $menuheader.$menuitems.$menufooter,
                         "mobile" => $mmenuheader.$menuitems.$mmenufooter
                    );
                }
            }
        }
        $mcourseids = array_slice($rcourseids, 0, 4);
        $strcourse = $mstrcourse = '';
        foreach ($mcourseids as $ctid => $marr) {
            $strcourse .= $marr["desk"]."\n";
            $mstrcourse .= $marr["mobile"]."\n";
        }

        $courseaurl = new moodle_url('/course/index.php');
        if (!empty($strcourse)) {
        $topcmenu = '<div class="custom-dropdown-menu" id="cr_menu" style="display:none;">
			<div class="cols-wrap">'.$strcourse.'
			  <div class="clearfix"></div>
			</div>
		</div>';
        } else {
            $topcmenu = "";
        }


        $topmmenu = '<ul class="dropdown-menu">
		  '.$mstrcourse.'<li>
            <a href="'.$courseaurl.'">'.get_string('viewall', 'theme_enlight').'</a>
         </li>
    </ul>';


        return compact('topcmenu', 'topmmenu');
    }

    private function category_menu2($count) {
        global $OUTPUT, $PAGE, $CFG, $DB, $USER;

        $page = optional_param('page', '0', PARAM_INT);
        $categoryid = optional_param('categoryid', null, PARAM_INT);
        $ctype = optional_param('ctype', null, PARAM_TEXT);
        $displaylist = coursecat::make_categories_list();

        if (empty($count)) {
            $countstr = '<p>No course available</p>';
        } else if ($count == "1") {
            $countstr = '<p>'.$count.' course</p>';
        } else if ($count > 1) {
            $countstr = '<p>'.$count.' course(s)</p>';
        }

        $options = $options1 = '';

        foreach ($displaylist as $cid => $cval) {
            $ctxt = ($categoryid == $cid) ? ' selected="selected" ' : '';
            $options .= "<option value='$cid'$ctxt>$cval</option>\n";
        }

        $dlist = array("asc" => "Asc", "desc" => "Desc");
        foreach ($dlist as $ct => $ctval) {
            $ctxt1 = ($ctype == $ct) ? ' selected="selected" ' : '';
            $options1 .= "<option value='$ct'$ctxt1>$ctval</option>\n";
        }

        $courseurl = new moodle_url("/course/index.php");

        $html = '<div class="theme-filters">
					<form action="'.$courseurl.'" name="frmcourse" method="post" id="frmcrs">
						<select name="categoryid">
							<option value="">Categories</option>
							'.$options.'
						</select>
						<select name="ctype">
							<option value="">Sort</option>
							'.$options1.'
						</select>
						'.$countstr.'
					</form>
				</div>';

        return $html;
    }

    /**
     * Display all courses for the custom layout full category listing page
     * @param array $mycourses
     * @return string
     */
    private function display_course2 ($mycourses) {
        global $OUTPUT, $CFG;
        require_once($CFG->dirroot.'/course/lib.php');
        $rcourses = array_chunk($mycourses, 4);
        $output = '';
        $noimgurl = $OUTPUT->image_url('no-image', 'theme');
        foreach ($rcourses as $rowcourse) {
            $coursestr = '<div class="row">';
            foreach ($rowcourse as $course) {
                $courseurl = new moodle_url('/course/view.php', array('id' => $course->id ));
                if ($course instanceof stdClass) {
                    require_once($CFG->libdir. '/coursecatlib.php');
                    $course = new course_in_list($course);
                }
                $imgurl = '';
                $summary = theme_enlight_strip_html_tags($course->summary);
                $summary = theme_enlight_course_trim_char($summary, 75);
                $context = context_course::instance($course->id);
                $nostudents = count_role_users(5, $context);
                $noteachers = count_role_users(3, $context);
                foreach ($course->get_course_overviewfiles() as $file) {
                    $isimage = $file->is_valid_image();
                    $imgurl = file_encode_url("$CFG->wwwroot/pluginfile.php",
                         '/'. $file->get_contextid(). '/'. $file->get_component(). '/'.
                        $file->get_filearea(). $file->get_filepath(). $file->get_filename(), !$isimage);
                    if (!$isimage) {
                        $imgurl = $noimgurl;
                    }
                }
                if (empty($imgurl)) {
                    $imgurl = $noimgurl;
                }
                $activities = get_array_of_activities($course->id);
                $countact = count($activities);
                $stlang = ($nostudents > 1) ? 'students' : 'defaultcoursestudent';
                $telang = ($noteachers > 1) ? 'teachers' : 'defaultcourseteacher';
                $aclang = ($countact > 1) ? 'activities' : 'activity';
                $coursestr .= '<div class="col-md-3">
						<div class="box">
							<div class="box-thumb">
								<a href="'.$courseurl.'"><img src="'.$imgurl.'" alt="img252-01.jpg"></a>
							</div>
							<div class="box-content">
								<h6 class="title-text"><a href="'.$courseurl.'">'.$course->fullname.'</a></h6>
								<hr>
								<p class="shortdesc">'.$summary.'</p>
								<hr>
								<div class="stat-info">
		<span title="'.$noteachers.' '.get_string($telang).'"><i class="fa fa-user"></i>'.$noteachers.'</span>
		<span title="'.$countact.' '.get_string($aclang).'"><i class="fa fa-clock-o"></i>'.$countact.'</span>
		<span title="'.$nostudents.' '.get_string($stlang).'"><i class="fa fa-group"></i>'.$nostudents.'</span>
									<div class="clearfix"></div>
								</div>
							</div>
						</div>
		</div>';
            }

            $coursestr .= '</div>';

            $output .= $coursestr;
        }
        return $output;
    }

    /**
     * Renderer function for the frontpage available courses.
     * @return string
     */
    public function frontpage_available_courses() {

        global $CFG, $OUTPUT, $PAGE, $DB;
        $course_container = '';
        $displayOption = theme_enlight_get_setting('availablecourse_displaytype');

        if ($displayOption == '0') {
            $content = html_writer::start_tag('div', array('class' => 'container'));
            $content .= html_writer::tag('h2', get_string('availablecourses'));
            $content .= parent::frontpage_available_courses();
            $content .= html_writer::end_tag('div');
            return $content;
        }
        require_once($CFG->libdir. '/coursecatlib.php');

        $chelper = new coursecat_helper();

        $chelper->set_show_courses(self::COURSECAT_SHOW_COURSES_EXPANDED)->set_courses_display_options(array(
            'recursive' => true,
            'limit' => $CFG->frontpagecourselimit,
            'viewmoreurl' => new moodle_url('/course/index.php'),
            'viewmoretext' => new lang_string('fulllistofcourses')
        ));

        $chelper->set_attributes( array( 'class' => 'frontpage-course-list-all' ) );

        $courses = coursecat::get(0)->get_courses( $chelper->get_courses_display_options() );

        $totalcount = coursecat::get(0)->get_courses_count( $chelper->get_courses_display_options() );

        $rcourseids = array_keys( $courses );

        $acourseids = array_chunk( $rcourseids, 6);

        $tcount = count($acourseids);

        $newcourse = get_string( 'availablecourses' );
        $header = "";
        $header .= html_writer::tag('div',"<div></div>",array('class'=>'bgtrans-overlay'));

        $header .= html_writer::start_tag('div',
            array( 'class' => 'available-courses', 'id' => 'available-courses') );
        $header .= html_writer::start_tag('div', array( 'class' => 'available-overlay' ) );
        $header .= html_writer::start_tag('div', array( 'class' => 'available-block' ) );
        $header .= html_writer::start_tag('div', array('class' => 'container'));
        $header .= html_writer::tag('h2', get_string('availablecourses'));

        if ($tcount > '1') {
            $header .='<div class="pagenav slider-nav">
                     <button class="slick-prev nav-item previous" type="button">
                     </button>
                     <button class="slick-next nav-item next" type="button">
                     </button>
                    <div class="clearfix"></div>
                   </div>';

        }
        $sliderClass = 'course-slider';
        $header .= html_writer::start_tag('div', array('class' => 'row') );
        $header .= html_writer::start_tag('div', array( 'class' => " $sliderClass col-md-12") );

        $footer = html_writer::end_tag('div');
        $footer .= html_writer::end_tag('div');
        $footer .= html_writer::end_tag('div');
        $footer .= html_writer::end_tag('div');
        if (count($rcourseids) > 0) {
            $i = '0';
            foreach ($acourseids as $courseids) {

                $rowcontent = '<div class="slider-row ">';

                foreach ($courseids as $courseid) {
                    $container = '';
                    $course = get_course($courseid);
                    $noimgurl = $OUTPUT->image_url('no-image', 'theme');
                    $courseurl = new moodle_url('/course/view.php', array('id' => $courseid ));

                    if ($course instanceof stdClass) {
                        require_once($CFG->libdir. '/coursecatlib.php');
                        $course = new course_in_list($course);
                    }

                    $imgurl = '';
                    $context = context_course::instance($course->id);

                    foreach ($course->get_course_overviewfiles() as $file) {
                        $isimage = $file->is_valid_image();
                        $imgurl = file_encode_url("$CFG->wwwroot/pluginfile.php",
                            '/'. $file->get_contextid(). '/'. $file->get_component(). '/'.
                            $file->get_filearea(). $file->get_filepath(). $file->get_filename(), !$isimage);
                        if (!$isimage) {
                            $imgurl = $noimgurl;
                        }
                    }

                    if (empty($imgurl)) {
                        $imgurl = $noimgurl;
                    }

                    $container .= html_writer::start_tag('div', array( 'class' => 'col-md-2') );
					$container .= html_writer::start_tag('div', array( 'class' => 'available-content'));
                    $container .= html_writer::start_tag('div', array( 'class' => 'available-img'));

                    $container .= html_writer::start_tag('a', array( 'href' => $courseurl) );
                    $container .= html_writer::empty_tag('img', array( 'src' => $imgurl ,
                        'width' => "249", 'height' => "200", 'alt' => $course->fullname ) );
                    $container .= html_writer::end_tag('a');
                    $container .= html_writer::end_tag('div');
                    $container .= html_writer::tag('h6', html_writer::tag('a', $course->fullname, array( 'href' => $courseurl ) ), array('class' => 'title-text') );
                    $container .= html_writer::end_tag('div');
					$container .= html_writer::end_tag('div');

                    $rowcontent .= $container;
                }
                $i++;
                $rowcontent .= ($displayOption != '1' && ($displayOption == '1' && $tcount < '1') ) ? html_writer::div('',  'clearfix' ) : '';

                $rowcontent .= html_writer::end_tag('div');
                $course_container .= $rowcontent;
            }

        }
        $footer .= html_writer::end_tag('div');
        $footer .= html_writer::end_tag('div');
        $coursehtml = $header.$course_container.$footer;

        return false;

        if (!$totalcount && !$this->page->user_is_editing() && has_capability('moodle/course:create', context_system::instance())) {
            // Print link to create a new course, for the 1st available category.
            echo $this->add_new_course_button();
        }

    }
    /**
     * Renderer function for frontpage enrolled courses.
     * @return string
     */
    public function frontpage_my_courses() {

        global $USER, $CFG, $DB, $OUTPUT, $PAGE;
        $course_container = "";
        $i='0';
        if (!isloggedin() or isguestuser()) {
            return '';
        }
        $coursehtml = '';
        $output = '';
        $displayOption  =  theme_enlight_get_setting('mycourse_displaytype');
        if ($displayOption == '0') {

            $content = html_writer::start_tag('div', array('class' => 'container'));
            $content .= html_writer::tag('h2', get_string('mycourses'));
            $coursehtml = parent::frontpage_my_courses();
             if ($coursehtml == '') {
                 $coursehtml = "<div id='mycourses'><style> #frontpage-course-list.frontpage-mycourse-list { display:none;} </style></div>";
            }
            $content .= $coursehtml;
            $content .= html_writer::end_tag('div');

            return $content;
        }

        if (!empty($CFG->navsortmycoursessort)) {
            // sort courses the same as in navigation menu
            $sortorder = 'visible DESC,'. $CFG->navsortmycoursessort.' ASC';
        } else {
            $sortorder = 'visible DESC,sortorder ASC';
        }
        $courses  = enrol_get_my_courses('summary, summaryformat', $sortorder);
        $rhosts   = array();
        $rcourses = array();
        if (!empty($CFG->mnet_dispatcher_mode) && $CFG->mnet_dispatcher_mode==='strict') {
            $rcourses = get_my_remotecourses($USER->id);
            $rhosts   = get_my_remotehosts();
        }

        if (!empty($courses) || !empty($rcourses) || !empty($rhosts)) {

            $chelper = new coursecat_helper();
            if (count($courses) > $CFG->frontpagecourselimit) {
                // There are more enrolled courses than we can display, display link to 'My courses'.
                $totalcount = count($courses);
                $courses = array_slice($courses, 0, $CFG->frontpagecourselimit, true);
                $chelper->set_courses_display_options(array(
                        'viewmoreurl' => new moodle_url('/my/'),
                        'viewmoretext' => new lang_string('mycourses')
                    ));
            } else {
                // All enrolled courses are displayed, display link to 'All courses' if there are more courses in system.
                $chelper->set_courses_display_options(array(
                        'viewmoreurl' => new moodle_url('/course/index.php'),
                        'viewmoretext' => new lang_string('fulllistofcourses')
                    ));
                $totalcount = $DB->count_records('course') - 1;
            }
            $chelper->set_show_courses(self::COURSECAT_SHOW_COURSES_EXPANDED)->
                    set_attributes(array('class' => 'frontpage-course-list-enrolled'));
          //  $output .= $this->coursecat_courses($chelper, $courses, $totalcount);

            $rcourseids = array_keys( $courses );
            $acourseids = array_chunk( $rcourseids, 6 );
            $tcount = count($acourseids);
            $header = "";
            $header .= html_writer::tag('div',"<div></div>",array('class'=>'bgtrans-overlay'));
            $header .= html_writer::start_tag('div',
            array( 'class' => 'my-courses', 'id' => 'mycourses') );
            $header .= html_writer::start_tag('div', array( 'class' => 'mycourses-overlay' ) );
            $header .= html_writer::start_tag('div', array( 'class' => 'mycourses-block' ) );
            $header .= html_writer::start_tag('div', array('class' => 'container'));
            $header .= html_writer::tag('h2', get_string('mycourses'));

            if ($displayOption == '1' && $tcount > '1') {
            $header .='<div class="pagenav slider-nav">
                     <button class="slick-prev nav-item previous" type="button">
                     </button>
                     <button class="slick-next nav-item next" type="button">
                     </button>
                    <div class="clearfix"></div>
                   </div>';

            }
            $sliderClass = 'mycourse-slider';
             $header .= html_writer::start_tag('div', array( 'class' => "row"));
            $header .= html_writer::start_tag('div', array( 'class' => " $sliderClass col-md-12") );

            $footer = html_writer::end_tag('div');
            $footer .= html_writer::end_tag('div');
            $footer .= html_writer::end_tag('div');
            $footer .= html_writer::end_tag('div');
            $footer .= html_writer::end_tag('div');
            $container = '';
            if (count($rcourseids) > 0) {
                $i='0';
                foreach ($acourseids as $courseids) {
                    $rowcontent = '<div class="slider-row ">';
                    foreach ($courseids as $courseid) {
                        $course = get_course($courseid);
                        $noimgurl = $OUTPUT->image_url('no-image', 'theme');
                        $courseurl = new moodle_url('/course/view.php', array('id' => $courseid ));

                        if ($course instanceof stdClass) {
                            require_once($CFG->libdir. '/coursecatlib.php');
                            $course = new course_in_list($course);
                        }

                        $imgurl = '';

                        foreach ($course->get_course_overviewfiles() as $file) {
                            $isimage = $file->is_valid_image();
                            $imgurl = file_encode_url("$CFG->wwwroot/pluginfile.php",
                                '/'. $file->get_contextid(). '/'. $file->get_component(). '/'.
                                $file->get_filearea(). $file->get_filepath(). $file->get_filename(), !$isimage);
                            if (!$isimage) {
                                $imgurl = $noimgurl;
                            }
                        }

                        if (empty($imgurl)) {
                            $imgurl = $noimgurl;
                        }

                        $container = html_writer::start_tag('div', array( 'class' => 'col-md-2') );
                        $container .= html_writer::start_tag('div', array( 'class' => 'available-content') );
                        $container .= html_writer::start_tag('div', array( 'class' => 'available-img'));
                        $container .= html_writer::start_tag('a', array( 'href' => $courseurl) );
                        $container .= html_writer::empty_tag('img', array( 'src' => $imgurl ,
                            'width' => "249", 'height' => "220", 'alt' => $course->fullname ) );
                        $container .= html_writer::end_tag('a');
                        $container .= html_writer::end_tag('div');
                        $container .= html_writer::tag('h6', html_writer::tag('a', $course->fullname, array( 'href' => $courseurl ) ) );
                        $container .= html_writer::end_tag('div');
                        $container .= html_writer::end_tag('div');

                        $rowcontent .= $container;
                    }
                    $i++;
                    $rowcontent .= ($displayOption != '1' && ($displayOption == "1" && $tcount < '1') ) ? html_writer::div('',  'clearfix' ) : '';
                    $rowcontent .= html_writer::end_tag('div');
                    $course_container .= $rowcontent;
                }
            }


        $footer .= html_writer::end_tag('div');

        $coursehtml = $header.$course_container.$footer;
        }

        if ($coursehtml == '') {

             $coursehtml = "<div id='mycourses'><style> #frontpage-course-list.frontpage-mycourse-list { display:none;} </style></div>";
        }

        return $coursehtml;
    }

    /**
     * Course search form renderer function.
     * @param type|string $value
     * @param type|string $format
     * @return type|string
     */
	public function course_search_form($value = '', $format = 'plain') {
        static $count = 0;
        $formid = 'coursesearch';
        if ((++$count) > 1) {
            $formid .= $count;
        }

        switch ($format) {
            case 'navbar' :
                $formid = 'coursesearchnavbar';
                $inputid = 'navsearchbox';
                $inputsize = 20;
                break;
            case 'short' :
                $inputid = 'shortsearchbox';
                $inputsize = 12;
                break;
            default :
                $inputid = 'coursesearchbox';
                $inputsize = 30;
        }
        global $PAGE;

        $strsearchcourses= get_string("searchcourses");
        $searchurl = new moodle_url('/course/search.php');
        $output = html_writer::start_tag('div', array('class' => 'search-block'));
        $output .= html_writer::start_tag('div', array('class' => 'container'));

        if ($PAGE->pagelayout == "frontpage"){
            $output .= html_writer::tag('h2', get_string('search_courses', 'theme_enlight'));
        }
        $output .= html_writer::start_tag('form', array('id' => $formid, 'action' => $searchurl, 'method' => 'get'));
        $output .= html_writer::start_tag('fieldset', array('class' => 'coursesearchbox invisiblefieldset'));
        $output .= html_writer::tag('label', $strsearchcourses.': ', array('for' => $inputid));
        $output .= html_writer::empty_tag('input', array('type' => 'text', 'id' => $inputid,
            'size' => $inputsize, 'name' => 'search', 'placeholder' => get_string('typesearch', 'theme_enlight'), 'value' => s($value)));
        $output .= html_writer::empty_tag('input', array('type' => 'submit',
            'value' => get_string('search', 'theme_enlight') ));
        $output .= html_writer::end_tag('fieldset');
        $output .= html_writer::end_tag('form');
        $output .= html_writer::end_tag('div');
        $output .= html_writer::end_tag('div');



        return false;// nao mostra nada
    }
    /**
     * Get the course details for the particular  id.
     * @param type $courseid
     * @param type|bool $clone
     * @return type
     */
    public function get_course($courseid, $clone = true) {
        global $DB, $COURSE, $SITE;
        if (!empty($COURSE->id) && $COURSE->id == $courseid) {
            return $clone ? clone($COURSE) : $COURSE;
        } else if (!empty($SITE->id) && $SITE->id == $courseid) {
            return $clone ? clone($SITE) : $SITE;
        } else {
            $content = $DB->get_record('course', array('id' => $courseid), '*', IGNORE_MISSING);
            if (!empty($content)) {
                return $content;
            }
        }
    }

    /**
     * Check the given id have the courses details.
     * @param type $rcourseids
     * @return type
     */
    public function check_course_id($rcourseids) {
        if(!empty($rcourseids)) {
            foreach($rcourseids as $key => $rcourseid ) {
                if (empty($rcourseid) && !is_integer($rcourseid)) {
                    unset($rcourseids[$key]);
                }
            }
        }
        return $rcourseids;
    }

} // Here the theme_enlight_course renderer fucntion closed.

