<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @package    theme_enlight
 * @copyright  2015 onwards LMSACE Dev Team (http://www.lmsace.com)
 * @author    LMSACE Dev Team
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die;


if ($ADMIN->fulltree) {


    $settings = new theme_boost_admin_settingspage_tabs('themesettingenlight', get_string('enlight_settings', 'theme_enlight'));

    /* General Settings */
    $temp = new admin_settingpage('theme_enlight_general', get_string('themegeneralsettings', 'theme_enlight'));

    // This is the descriptor for Slide One.
    $name = 'theme_enlight/theme_enlight_generalsub1';
    $heading = get_string('generallogo_menu', 'theme_enlight');
    $information = "";
    $setting = new admin_setting_heading($name, $heading, $information);
    $temp->add($setting);

    $name = 'theme_enlight/patternselect';
    $title = get_string('patternselect' , 'theme_enlight');
    $description = get_string('patternselectdesc', 'theme_enlight');
    $default = 'default';
    $choices = array(
        'default' => get_string("blue","theme_enlight"),
        '1' => get_string("green","theme_enlight"),
        '2' => get_string("lavender","theme_enlight"),
        '3' => get_string("red","theme_enlight"),
        '4' => get_string("purple","theme_enlight")
    );

    $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
    $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    $pimg = array();
    global $CFG;

    $cp = $CFG->wwwroot.'/theme/enlight/pix/color/';
    $pimg = array($cp.'default.jpg', $cp.'pattern-1.jpg', $cp.'pattern-2.jpg',
            $cp.'pattern-3.jpg', $cp.'pattern-4.jpg'
    );

    $themepattern = '<ul class="thumbnails theme-color-schemes">
	 <li class="col-md-2">
	   <div class="thumbnail">
      <img src="'.$pimg[0].'" alt="default" width="100" height="100" />
        <h6>'.get_string("blue","theme_enlight").'</h6>
		</div>
	</li>
	 <li class="col-md-2">
	   <div class="thumbnail">
      <img src="'.$pimg[1].'" alt="pattern1" width="100" height="100" />
       <h6>'.get_string("green","theme_enlight").'</h6>
		</div>
	 </li>
     <li class="col-md-2">
	   <div class="thumbnail">
      <img src="'.$pimg[2].'" alt="pattern2" width="100" height="100" />
       <h6>'.get_string("lavender","theme_enlight").'</h6>
		</div>
	</li>
	  <li class="col-md-2">
	   <div class="thumbnail">
      <img src="'.$pimg[3].'" alt="pattern3" width="100" height="100" />
	  <h6>'.get_string("red","theme_enlight").'</h6>
		</div>
	</li>
      <li class="col-md-2">
	   <div class="thumbnail">
      <img src="'.$pimg[4].'" alt="pattern4" width="100" height="100" />
       <h6>'.get_string("purple","theme_enlight").'</h6>
		</div>
	  </li>
</ul>';

    $temp->add(new admin_setting_heading('theme_enlight_patternheading', '', $themepattern));

    $name = 'theme_enlight/headerStyle';
    $title = get_string('headerStyle', 'theme_enlight');
    $description = get_string('headerStyle_desc', 'theme_enlight');
    $themeColor = get_string('header', 'theme_enlight', array('no' => '1'));
    $whiteColor = get_string('header', 'theme_enlight', array('no' => '2'));
    $default = 1;
    $choices = array(1 => $themeColor , 2 => $whiteColor);
    $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

     // Logo file setting.
    $name = 'theme_enlight/logo';
    $title = get_string('logo', 'theme_enlight');
    $description = get_string('logodesc', 'theme_enlight');
    $setting = new admin_setting_configstoredfile($name, $title, $description, 'logo');
    $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Primary menu position.
    $name = 'theme_enlight/primarymenu';
    $title = get_string('primarymenu', 'theme_enlight');
    $description = get_string('primarymenudesc', 'theme_enlight');
    $default = get_string('primary_menu', 'theme_enlight');
    $setting = new admin_setting_configtextarea($name, $title, $description, $default);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    //  Course menu.
    $name = 'theme_enlight/cmenushow';
    $title = get_string('cmenushow', 'theme_enlight');
    $description = get_string('cmenushowdesc', 'theme_enlight');
    $default = 1;
    $setting = new admin_setting_configcheckbox($name, $title, $description, $default);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    //  Course menu position.
    $name = 'theme_enlight/cmenuPosition';
    $title = get_string('cmenuPosition', 'theme_enlight');
    $description = get_string('cmenuPosition_desc', 'theme_enlight');
    $default = '2';
    $setting = new admin_setting_configtext($name, $title, $description, $default, PARAM_TEXT);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // This is the descriptor for Slide One.
    $name = 'theme_enlight/theme_enlight_managefrontpage';
    $heading = get_string('managefrontpage_items', 'theme_enlight');
    $information = "";//get_string('slidenodesc', 'theme_enlight', array('slide' => $i));
    $setting = new admin_setting_heading($name, $heading, $information);
    $temp->add($setting);

    // Popular Course Display Status.
    $name = 'theme_enlight/popularCourse_status';
    $title = get_string('popularCourse_status', 'theme_enlight');
    $description = get_string('popularCourse_statusdesc', 'theme_enlight');
    $yes = get_string('yes');
    $no = get_string('no');
    $default = 1;
    $choices = array(1 => $yes , 0 => $no);
    $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);
    // Popular Course Display Status.


    $name = 'theme_enlight/popularCourse_type';
    $title = get_string('popularCourses_type', 'theme_enlight');
    $description = get_string('popularCourse_typedesc', 'theme_enlight');
    $enrolBase = get_string('no_enrol','theme_enlight');
    $idBase = get_string('id_base', 'theme_enlight');
    $default = 1;
    $choices = array(1 => $enrolBase , 2 => $idBase);
    $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    $name = 'theme_enlight/popularCourse_id';
    $title = get_string('popularCourses_id', 'theme_enlight');
    $description = get_string('popularCourse_iddesc', 'theme_enlight');
    $default = "";
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Available Course Display Status.
    $name = 'theme_enlight/availablecourse_displaytype';
    $title = get_string('acourse_displaytype' , 'theme_enlight');
    $description = get_string('acourse_displaytypedesc', 'theme_enlight');
    $default = '1';
    $choices = array(
        '0' => get_string('default_type','theme_enlight'),
        '1' => get_string('slider_type', 'theme_enlight'),

    );
    $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    $name = 'theme_enlight/categories_displaytype';
    $title = get_string('categories_displaytype' , 'theme_enlight');
    $description = get_string('categories_displaytypedesc', 'theme_enlight');
    $default = '1';
    $choices = array(
        '0' => get_string('default_type','theme_enlight'),
        '1' => get_string('slider_type', 'theme_enlight'),

    );
    $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);




    // Mycourse Course Display Type.
    $name = 'theme_enlight/mycourse_displaytype';
    $title = get_string('mycourse_displaytype' , 'theme_enlight');
    $description = get_string('mycourse_displaytypedesc', 'theme_enlight');
    $default = '1';
    $choices = array(
        '0' => get_string('default_type','theme_enlight'),
        '1' => get_string('slider_type', 'theme_enlight'),

    );

    $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

// Site news type
    $name = 'theme_enlight/sitenewsType';
    $title = get_string('sitenewsType', 'theme_enlight');
    $description = get_string('sitenewsType_desc', 'theme_enlight');
    $yes = get_string('enlight_type', 'theme_enlight');
    $no = get_string('default_type', 'theme_enlight');
    $default = 1;
    $choices = array( 0 => $no , 1 => $yes );
    $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
    $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // combo list box type
    $name = 'theme_enlight/comboListboxType';
    $title = get_string('comboListboxType', 'theme_enlight');
    $description = get_string('comboListboxType_desc', 'theme_enlight');
    $expand = get_string('expand', 'theme_enlight');
    $collapse = get_string('collapse', 'theme_enlight');
    $default = 1;
    $choices = array(0 => $expand, 1 => $collapse);
    $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);


    // This is the descriptor for Slide One.
    $name = 'theme_enlight/theme_enlight_managebgimages';
    $heading = get_string('managebgimages', 'theme_enlight');
    $information = "";//get_string('slidenodesc', 'theme_enlight', array('slide' => $i));
    $setting = new admin_setting_heading($name, $heading, $information);
    $temp->add($setting);

    $name = 'theme_enlight/popularcoursesbg';
    $title = get_string('popularcoursesbg', 'theme_enlight');
    $description = get_string('popularcoursesbg_desc', 'theme_enlight');
    $setting = new admin_setting_configstoredfile($name, $title, $description, 'popularcoursesbg');
    $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    $name = 'theme_enlight/popularcoursesbg_type';
    $title = get_string('popularcoursebg_type', 'theme_enlight');
    $description = get_string('popularcoursebg_typedesc', 'theme_enlight');
    $overlay = get_string('overlay', 'theme_enlight');
    $imgcolor = get_string('imagecolor', 'theme_enlight');
    $default = 2;
    $choices = array( 1 => $overlay, 2 => $imgcolor);
    $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
    $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Available courses setting bgimages.
    $name = 'theme_enlight/availablecoursesbg';
    $title = get_string('availablecoursesbg', 'theme_enlight');
    $description = get_string('availablecoursesbg_desc', 'theme_enlight');
    $setting = new admin_setting_configstoredfile($name, $title, $description, 'availablecoursesbg');
    $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    $name = 'theme_enlight/availablecoursesbg_type';
    $title = get_string('availablecoursebg_type', 'theme_enlight');
    $description = get_string('availablecoursebg_typedesc', 'theme_enlight');
    $overlay = get_string('overlay', 'theme_enlight');
    $imgcolor = get_string('imagecolor', 'theme_enlight');
    $none = get_string('bgnone', 'theme_enlight');
    $default = 1;
    $choices = array( 1 => $overlay, 2 => $imgcolor, "NONE" => $none);
    $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
    $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Enrolled courses setting bgimages.
    $name = 'theme_enlight/categoriesbg';
    $title = get_string('categoriescoursesbg', 'theme_enlight');
    $description = get_string('categoriesbg_desc', 'theme_enlight');
    $setting = new admin_setting_configstoredfile($name, $title, $description, 'categoriesbg');
    $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    $name = 'theme_enlight/categoriesbg_type';
    $title = get_string('categoriesbg_type', 'theme_enlight');
    $description = get_string('categoriesbg_typedesc', 'theme_enlight');
    $overlay = get_string('overlay', 'theme_enlight');
    $imgcolor = get_string('imagecolor', 'theme_enlight');
    $none = get_string('bgnone', 'theme_enlight');
    $default = "NONE";
    $choices = array( 1 => $overlay, 2 => $imgcolor, "NONE" => $none);
    $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
    $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Enrolled courses setting bgimages.
    $name = 'theme_enlight/enrolledcoursesbg';
    $title = get_string('enrolledcoursesbg', 'theme_enlight');
    $description = get_string('enrolledcoursesbg_desc', 'theme_enlight');
    $setting = new admin_setting_configstoredfile($name, $title, $description, 'enrolledcoursesbg');
    $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Enrolled courses backgrond type
    $name = 'theme_enlight/enrolledcoursesbg_type';
    $title = get_string('enrolledcoursebg_type', 'theme_enlight');
    $description = get_string('enrolledcoursebg_typedesc', 'theme_enlight');
    $overlay = get_string('overlay', 'theme_enlight');
    $imgcolor = get_string('imagecolor', 'theme_enlight');
    $none = get_string('bgnone', 'theme_enlight');
    $default = 1;
    $choices = array( 1 => $overlay, 2 => $imgcolor, "NONE" => $none);
    $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
    $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    /* Login BG Image file setting */
    $name = 'theme_enlight/testimonialsbg';
    $title = get_string('testimonialsbg', 'theme_enlight');
    $description = get_string('testimonialsbg_desc', 'theme_enlight');
    $setting = new admin_setting_configstoredfile($name, $title, $description, 'testimonialsbg');
    $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Testimanials Backgrond image
    $name = 'theme_enlight/testimonialsbg_type';
    $title = get_string('testimonialsbg_type', 'theme_enlight');
    $description = get_string('testimonialsbg_typedesc', 'theme_enlight');
    $overlay = get_string('overlay', 'theme_enlight');
    $imgcolor = get_string('imagecolor', 'theme_enlight');

    $default = 2;
    $choices = array( 1 => $overlay, 2 => $imgcolor);
    $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
    $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Footer background images
    $name = 'theme_enlight/footbgimg';
    $title = get_string('footbgimg', 'theme_enlight');
    $description = get_string('footbgimg_desc', 'theme_enlight');
    $setting = new admin_setting_configstoredfile($name, $title, $description, 'footbgimg');
    $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Footer Background Images.
    $name = 'theme_enlight/footbgimg_type';
    $title = get_string('footbgimg_type', 'theme_enlight');
    $description = get_string('footbgimg_type_desc', 'theme_enlight');
    $overlay = get_string('overlay', 'theme_enlight');
    $imgcolor = get_string('imagecolor', 'theme_enlight');
    $default = 2;
    $choices = array( 1 => $overlay, 2 => $imgcolor);
    $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
    $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    /* Login BG Image file setting */
    $name = 'theme_enlight/loginbg';
    $title = get_string('loginbg', 'theme_enlight');
    $description = get_string('loginbgdesc', 'theme_enlight');
    $setting = new admin_setting_configstoredfile($name, $title, $description, 'loginbg');
    $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // This is the descriptor for Slide One.
    $name = 'theme_enlight/theme_enlight_miscellaneous';
    $heading = get_string('miscellaneous', 'theme_enlight');
    $information = "";//get_string('slidenodesc', 'theme_enlight', array('slide' => $i));
    $setting = new admin_setting_heading($name, $heading, $information);
    $temp->add($setting);

   /* Course Layout */
    $name = 'theme_enlight/courselayout';
    $title = get_string('courselayout' , 'theme_enlight');
    $description = get_string('courselayoutdesc', 'theme_enlight');
    $default = 'layout1';
    $choices = array(
        'default' => get_string('default_layout','theme_enlight'),
        'layout1' => get_string('custom_layout', 'theme_enlight').'-1',
        'layout2' => get_string('custom_layout', 'theme_enlight').'-2'
    );
    $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);
    /* Course Layout */

    // Loginpage Type.
    $name = 'theme_enlight/loginpageType';
    $title = get_string('loginpageType', 'theme_enlight');
    $description = get_string('loginpageType_desc', 'theme_enlight');
    $yes = get_string('logintheme', 'theme_enlight');
    $no = get_string('default_type', 'theme_enlight')." " .get_string('style', 'theme_enlight');
    $default = 1;
    $choices = array( 0 => $no , 1 => $yes );
    $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Preloader Status.
    $name = 'theme_enlight/preloader_status';
    $title = get_string('preloader_status', 'theme_enlight');
    $description = get_string('preloader_statusdesc', 'theme_enlight');
    $yes = get_string('yes');
    $no = get_string('no');
    $default = 1;
    $choices = array(1 => $yes , 0 => $no);
    $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
    $temp->add($setting);

    // Preloader Color.
    $name = 'theme_enlight/preloaderbg_color';
    $title = get_string('preloaderbg_color', 'theme_enlight').' 1 '.get_string('bgcolor', 'theme_enlight');
    $description = get_string('preloaderbg_colordesc', 'theme_enlight');
    $default = "#353535";
    $previewconfig = null;
    $setting = new admin_setting_configcolourpicker($name, $title, $description, $default, $previewconfig);
    $temp->add($setting);

    //  Preloader Image.
    $name = 'theme_enlight/preloader';
    $title = get_string('preloader', 'theme_enlight');
    $description = get_string('preloader_desc', 'theme_enlight');
    $setting = new admin_setting_configstoredfile($name, $title, $description, 'preloader');
    $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Back to top button
    $name = 'theme_enlight/backToTop_status';
    $title = get_string('backToTop_status', 'theme_enlight');
    $description = get_string('backToTop_statusdesc', 'theme_enlight');
    $yes = get_string('yes');
    $no = get_string('no');
    $default = 1;
    $choices = array(1 => $yes , 0 => $no);
    $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
    $temp->add($setting);

    // Custom CSS file.
    $name = 'theme_enlight/customcss';
    $title = get_string('customcss', 'theme_enlight');
    $description = get_string('customcssdesc', 'theme_enlight');
    $default = '';
    $setting = new admin_setting_configtextarea($name, $title, $description, $default);
    $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Import Demo Content
    $name = 'theme_enlight/importDemo';
    $title = get_string('importDemo', 'theme_enlight');
    $description = get_string('importDemo_desc', 'theme_enlight');
    $default = 0;
    $setting = new admin_setting_configcheckbox($name, $title, $description, $default);
    $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);


    $settings->add($temp);
    // General settings end.

    /* Slideshow Settings Start */

    $temp = new admin_settingpage('theme_enlight_slideshow', get_string('slideshowheading', 'theme_enlight'));
    $temp->add(new admin_setting_heading('theme_enlight_slideshow', get_string('slideshowheadingsub', 'theme_enlight'),
    format_text(get_string('slideshowdesc', 'theme_enlight'), FORMAT_MARKDOWN)));

    // Number of slides.
    $name = 'theme_enlight/numberofslides';
    $title = get_string('numberofslides', 'theme_enlight');
    $description = get_string('numberofslidesdesc', 'theme_enlight');
    $default = 1;
    $choices = array(
        1 => '1',
        2 => '2',
        3 => '3',
        4 => '4',
        5 => '5',
        6 => '6',
        7 => '7',
        8 => '8',
        9 => '9',
        10 => '10',
        11 => '11',
        12 => '12',
    );
    $temp->add(new admin_setting_configselect($name, $title, $description, $default, $choices));

    // SlideShow Status
    $name = 'theme_enlight/slideshowStatus';
    $title = get_string('slideshowStatus', 'theme_enlight');
    $description = get_string('slideshowStatus_desc', 'theme_enlight');
    $yes = get_string('yes');
    $no = get_string('no' );
    $default = 1;
    $choices = array(1 => $yes , 0 => $no);
    $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);
    // Auto Scroll.
    $name = 'theme_enlight/autoslideshow';
    $title = get_string('autoslideshow', 'theme_enlight');
    $description = get_string('autoslideshowdesc', 'theme_enlight');
    $yes = get_string('yes');
    $no = get_string('no');
    $default = 1;
    $choices = array(1 => $yes , 0 => $no);
    $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    $name = 'theme_enlight/loaderStatus';
    $title = get_string('loaderStatus', 'theme_enlight');
    $description = get_string('loaderStatus_desc', 'theme_enlight');
    $yes = get_string('show');
    $no = get_string('hide' );
    $default = 1;
    $choices = array(1 => $yes , 0 => $no);
    $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Auto Scroll.
    $name = 'theme_enlight/slideshowpagination';
    $title = get_string('pagination', 'theme_enlight');
    $description = get_string('pagination_desc', 'theme_enlight');
    $dot = get_string('dots', 'theme_enlight');
    $dotThumb = get_string('dotThumb', 'theme_enlight');
    $thumb = get_string('thumbnails', 'theme_enlight');
    $none = get_string('pagi_none', 'theme_enlight');
    $default = "DOT";
    $choices = array( "DOTTHUMB" => $dotThumb, "THUMB" => $thumb, "DOT" => $dot, "NONE" => $none);
    $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Slide Show Interval.
    $name = 'theme_enlight/slideinterval';
    $title = get_string('slideinterval', 'theme_enlight');
    $description = get_string('slideintervaldesc', 'theme_enlight');
    $default = 3500;
    $setting = new admin_setting_configtext($name, $title, $description, $default, PARAM_INT);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Slideshow height.
    $name = 'theme_enlight/slideHeight';
    $title = get_string('slideheight', 'theme_enlight');
    $description = get_string('slideheight_desc', 'theme_enlight');
    $default = '550';
    $setting = new admin_setting_configtext($name, $title, $description, $default, PARAM_TEXT);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Slide Overlay Opacity.
    $name = 'theme_enlight/slideOverlay_opacity';
    $title = get_string('slideOverlay', 'theme_enlight');
    $description = get_string('slideOverlay_desc', 'theme_enlight');
    $opacity = array();
    $opacity = array_combine(range(0, 1, 0.1 ), range(0, 1, 0.1 ));
    $setting = new admin_setting_configselect($name, $title, $description, '0.4', $opacity);
    $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);
    $animations = array(
        "NONE" => get_string('none', 'theme_enlight'),
        "flash" => get_string('flash', 'theme_enlight'),
        "bounceIn" => get_string('bounceIn', 'theme_enlight'),
        "bounceInDown" => get_string('bounceInDown', 'theme_enlight'),
        "bounceInLeft" => get_string('bounceInLeft', 'theme_enlight'),
        "bounceInRight" => get_string('bounceInRight', 'theme_enlight'),
        "bounceInUp" => get_string('bounceInUp', 'theme_enlight'),
        "fadeIn" => get_string('fadeIn', 'theme_enlight'),
        "fadeInDown" => get_string('fadeInDown', 'theme_enlight'),
        "fadeInDownBig" => get_string('fadeInDownBig', 'theme_enlight'),
        "fadeInLeft" => get_string('fadeInLeft', 'theme_enlight'),
        "fadeInLeftBig" => get_string('fadeInLeftBig', 'theme_enlight'),
        "fadeInRight" => get_string('fadeInRight', 'theme_enlight'),
        "fadeInRightBig" => get_string('fadeInRightBig', 'theme_enlight'),
        "fadeInUp" => get_string('fadeInUp', 'theme_enlight'),
        "fadeInUpBig" => get_string('fadeInUpBig', 'theme_enlight'),
        "fadeOut" => get_string('fadeOut', 'theme_enlight'),
        "flip" => get_string('flip', 'theme_enlight'),
        "flipInX" => get_string('flipInX', 'theme_enlight'),
        "flipInY" => get_string('flipInY', 'theme_enlight'),
        "flipOutX" => get_string('flipOutX', 'theme_enlight'),
        "flipOutY" => get_string('flipOutY', 'theme_enlight'),
        "lightSpeedIn" => get_string('lightSpeedIn', 'theme_enlight'),
        "rotateIn" => get_string('rotateIn', 'theme_enlight'),
        "rotateInDownLeft" => get_string('rotateInDownLeft', 'theme_enlight'),
        "rotateInDownRight" => get_string('rotateInDownRight', 'theme_enlight'),
        "rotateInUpLeft" => get_string('rotateInUpLeft', 'theme_enlight'),
        "rotateInUpRight" => get_string('rotateInUpRight', 'theme_enlight'),
        "slideInUp" => get_string('slideInUp', 'theme_enlight'),
        "slideInDown" => get_string('slideInDown', 'theme_enlight'),
        "slideInLeft" => get_string('slideInLeft', 'theme_enlight'),
        "slideInRight" => get_string('slideInRight', 'theme_enlight'),
        "zoomIn" => get_string('zoom-In', 'theme_enlight'),
        "zoomInDown" => get_string('zoomInDown', 'theme_enlight'),
        "zoomInLeft" => get_string('zoomInLeft', 'theme_enlight'),
        "zoomInRight" => get_string('zoomInRight', 'theme_enlight'),
        "zoomInUp" => get_string('zoomInUp', 'theme_enlight'),
        "hinge" => get_string('hinge', 'theme_enlight'),
        "rollIn" => get_string('rollIn', 'theme_enlight'),
    );

    $effects = array(
        "scrollRight" => get_string('none', 'theme_enlight'),
        'random'   =>  get_string('random','theme_enlight'),
        'simpleFade'   =>  get_string('simpleFade','theme_enlight'),
        'curtainTopLeft'   =>  get_string('curtainTopLeft','theme_enlight'),
        'curtainTopRight'  =>  get_string('curtainTopRight','theme_enlight'),
        'curtainBottomLeft'    =>  get_string('curtainBottomLeft','theme_enlight'),
        'curtainBottomRight'   =>  get_string('curtainBottomRight','theme_enlight'),
        'curtainSliceLeft' =>  get_string('curtainSliceLeft','theme_enlight'),
        'curtainSliceRight'    =>  get_string('curtainSliceRight','theme_enlight'),
        'blindCurtainTopLeft'  =>  get_string('blindCurtainTopLeft','theme_enlight'),
        'blindCurtainTopRight' =>  get_string('blindCurtainTopRight','theme_enlight'),
        'blindCurtainBottomLeft'   =>  get_string('blindCurtainBottomLeft','theme_enlight'),
        'blindCurtainBottomRight'  =>  get_string('blindCurtainBottomRight','theme_enlight'),
        'blindCurtainSliceBottom'  =>  get_string('blindCurtainSliceBottom','theme_enlight'),
        'blindCurtainSliceTop' =>  get_string('blindCurtainSliceTop','theme_enlight'),
        'stampede' =>  get_string('stampede','theme_enlight'),
        'mosaic'   =>  get_string('mosaic','theme_enlight'),
        'mosaicReverse'    =>  get_string('mosaicReverse','theme_enlight'),
        'mosaicRandom' =>  get_string('mosaicRandom','theme_enlight'),
        'mosaicSpiral' =>  get_string('mosaicSpiral','theme_enlight'),
        'mosaicSpiralReverse'  =>  get_string('mosaicSpiralReverse','theme_enlight'),
        'topLeftBottomRight'   =>  get_string('topLeftBottomRight','theme_enlight'),
        'bottomRightTopLeft'   =>  get_string('bottomRightTopLeft','theme_enlight'),
        'bottomLeftTopRight'   =>  get_string('bottomLeftTopRight','theme_enlight'),
        'bottomLeftTopRight'   =>  get_string('bottomLeftTopRight','theme_enlight'),
        'scrollLeft'   =>  get_string('scrollLeft','theme_enlight'),
        'scrollRight'  =>  get_string('scrollRight','theme_enlight'),
        'scrollHorz'   =>  get_string('scrollHorz','theme_enlight'),
        'scrollBottom' =>  get_string('scrollBottom','theme_enlight'),
        'scrollTop' =>  get_string('scrollTop','theme_enlight'),

        );


    $numberofslides = get_config('theme_enlight', 'numberofslides');
    for ($i = 1; $i <= $numberofslides; $i++) {

        // This is the descriptor for Slide One.
        $name = 'theme_enlight/slide' . $i . 'info';
        $heading = get_string('slideno', 'theme_enlight', array('slide' => $i));
        $information = "";//get_string('slidenodesc', 'theme_enlight', array('slide' => $i));
        $setting = new admin_setting_heading($name, $heading, $information);
        $temp->add($setting);

        // SlideShow Status
        $name = 'theme_enlight/slide'.$i.'status';
        $title = get_string('slideStatus', 'theme_enlight', array('slide' => $i));
        $description = get_string('slideStatus_desc', 'theme_enlight', array('slide' => $i));
        $yes = get_string('enable', 'theme_enlight');
        $no = get_string('disable', 'theme_enlight');
        $default = 1;
        $choices = array(1 => $yes , 0 => $no);
        $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
        // $setting->set_updatedcallback('theme_reset_all_caches');
        $temp->add($setting);
        // Slide Image.
        $name = 'theme_enlight/slide' . $i . 'image';
        $title = get_string('slideimage', 'theme_enlight', array('slide' => $i));
        $description = get_string('slideimagedesc', 'theme_enlight');
        $setting = new admin_setting_configstoredfile($name, $title, $description, 'slide' . $i . 'image');
        $setting->set_updatedcallback('theme_reset_all_caches');
        $temp->add($setting);

        // Slide Caption.
        $name = 'theme_enlight/slide' . $i . 'caption';
        $title = get_string('slidecaption', 'theme_enlight', array('slide' => $i));
        $description = get_string('slidecaptiondesc', 'theme_enlight');
        $default = 'lang:slidecaptiondefault';
        $setting = new admin_setting_configtext($name, $title, $description, $default, PARAM_TEXT);
        // $setting->set_updatedcallback('theme_reset_all_caches');
        $temp->add($setting);

        // Slide Description Text.
        $name = 'theme_enlight/slide' . $i . 'desc';
        $title = get_string('slidedesc', 'theme_enlight', array('slide' => $i));
        $description = get_string('slidedesctext', 'theme_enlight');
        $default = 'lang:slidedescdefault';
        $setting = new admin_setting_configtextarea($name, $title, $description, $default, PARAM_TEXT);
        // $setting->set_updatedcallback('theme_reset_all_caches');
        $temp->add($setting);

        // Slide Link text.
        $name = 'theme_enlight/slide' . $i . 'urltext1';
        $title = get_string('slideurl1text', 'theme_enlight', array('type' => "1"));
        $description = get_string('slideurl1textdesc', 'theme_enlight');
        $default = 'lang:knowmore';
        $setting = new admin_setting_configtext($name, $title, $description, $default, PARAM_TEXT);
        // $setting->set_updatedcallback('theme_reset_all_caches');
        $temp->add($setting);

        // Slide Url.
        $name = 'theme_enlight/slide' . $i . 'url1';
        $title = get_string('slideurl1', 'theme_enlight', array('type' => "1"));
        $description = get_string('slideurl1desc', 'theme_enlight');
        $default = 'http://www.example.com/';
        $setting = new admin_setting_configtext($name, $title, $description, $default, PARAM_URL);
        // $setting->set_updatedcallback('theme_reset_all_caches');
        $temp->add($setting);

        $name = 'theme_enlight/slide'.$i.'urltarget1';
        $title = get_string('urltarget1', 'theme_enlight', array('type' => "1"));
        $description = get_string('urltarget_desc', 'theme_enlight', array('slide' => $i));
        $same = get_string('sameWindow', 'theme_enlight');
        $new = get_string('newWindow', 'theme_enlight');
        $default = 1;
        $choices = array(0 => $same , 1 => $new);
        $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
        // $setting->set_updatedcallback('theme_reset_all_caches');
        $temp->add($setting);

        // Slide Link text.
        $name = 'theme_enlight/slide' . $i . 'urltext2';
        $title = get_string('slideurl2text', 'theme_enlight', array('type' => "2"));
        $description = get_string('slideurl2textdesc', 'theme_enlight');
        $default = 'lang:knowmore';
        $setting = new admin_setting_configtext($name, $title, $description, $default, PARAM_TEXT);
        // $setting->set_updatedcallback('theme_reset_all_caches');
        $temp->add($setting);

        // Slide Url.
        $name = 'theme_enlight/slide' . $i . 'url2';
        $title = get_string('slideurl2', 'theme_enlight', array('type' => "2"));
        $description = get_string('slideurl2desc', 'theme_enlight');
        $default = 'http://www.example.com/';
        $setting = new admin_setting_configtext($name, $title, $description, $default, PARAM_URL);
        // $setting->set_updatedcallback('theme_reset_all_caches');
        $temp->add($setting);

        $name = 'theme_enlight/slide'.$i.'urltarget2';
        $title = get_string('urltarget2', 'theme_enlight', array('type' => "2"));
        $description = get_string('urltarget_desc', 'theme_enlight', array('slide' => $i));
        $same = get_string('sameWindow', 'theme_enlight');
        $new = get_string('newWindow', 'theme_enlight');
        $default = 1;
        $choices = array(0 => $same , 1 => $new);
        $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
        // $setting->set_updatedcallback('theme_reset_all_caches');
        $temp->add($setting);

        $name = 'theme_enlight/slide' . $i . 'contFullwidth';
        $title = get_string('slideCont_full', 'theme_enlight');
        $description = get_string('slideCont_fulldesc', 'theme_enlight');
        $default = "50";
        $setting = new admin_setting_configtext($name, $title, $description, $default);
        $setting->set_updatedcallback('theme_reset_all_caches');
        $temp->add($setting);

        $name = 'theme_enlight/slide'. $i .'contentStyle';
        $title = get_string('slideContentStyle', 'theme_enlight');
        $description = get_string('slideContentStyle_desc', 'theme_enlight');

        $contentOverlay = get_string('contentOverlay', 'theme_enlight');
        $sliderOverlay = get_string('sliderOverlay', 'theme_enlight');
        $doubleHeading = get_string('doubleHeading', 'theme_enlight');
        $themebased = get_string('themebased', 'theme_enlight');

        $default = 2;
        $choices = array( 2 => $contentOverlay, 4 => $sliderOverlay, 3 => $doubleHeading, 1 => $themebased);
        $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
        // $setting->set_updatedcallback('theme_reset_all_caches');
        $temp->add($setting);


         // Slider content position.
        $name = 'theme_enlight/slide' . $i . 'contentPosition';
        $title = get_string('slidecontent', 'theme_enlight', array('slide' => $i));
        $description = get_string('slidecontentdesc', 'theme_enlight');

        $topLeft = get_string("topLeft", "theme_enlight");
        $topCenter = get_string("topCenter", "theme_enlight");
        $topRight = get_string("topRight", "theme_enlight");
        $centerLeft = get_string("centerLeft", "theme_enlight");
        $center = get_string("center", "theme_enlight");
        $centerRight = get_string("centerRight", "theme_enlight");
        $bottomLeft = get_string("bottomLeft", "theme_enlight");
        $bottomCenter = get_string("bottomCenter", "theme_enlight");
        $bottomRight = get_string("bottomRight", "theme_enlight");

        $default = 'centerRight';
        $choicesD = array(
            "topLeft" => $topLeft,
            "topCenter" => $topCenter,
            "topRight" => $topRight,
            "centerLeft" => $centerLeft,
            "center" => $center,
            "centerRight" => $centerRight,
            "bottomLeft" => $bottomLeft,
            "bottomCenter" => $bottomCenter,
            "bottomRight" => $bottomRight,
            );

        $setting = new admin_setting_configselect($name, $title, $description, $default, $choicesD);
        // $setting->set_updatedcallback('theme_reset_all_caches');
        $temp->add($setting);

        $name = 'theme_enlight/slide' . $i . 'contentAnimation';
        $title = get_string('contentAnimate', 'theme_enlight', array('slide' => $i));
        $description = get_string('contentAnimatedesc', 'theme_enlight');
        $default = 'fadeInLeft';
        $setting = new admin_setting_configselect($name, $title, $description, $default, $animations);
        // $setting->set_updatedcallback('theme_reset_all_caches');
        $temp->add($setting);

        $name = 'theme_enlight/slide' . $i . 'effect';
        $title = get_string('slideEffect', 'theme_enlight', array('slide' => $i));
        $description = get_string('slideEffectdesc', 'theme_enlight');
        $default = 'random';
        $setting = new admin_setting_configselect($name, $title, $description, $default, $effects);
        // $setting->set_updatedcallback('theme_reset_all_caches');
        $temp->add($setting);

        /*$name = 'theme_enlight/slide' . $i . 'imagePosition';
        $title = get_string('slideImgpos', 'theme_enlight');
        $description = get_string('slideImgpos_desc', 'theme_enlight');
        $default = "none";
        $setting = new admin_setting_configselect($name, $title, $description, $default, $choicesE);
        // $setting->set_updatedcallback('theme_reset_all_caches');
        $temp->add($setting);*/

    }

$settings->add($temp);

    /* Slideshow Settings End*/


    /* Front Page Settings */
    $temp = new admin_settingpage('theme_enlight_marketingspot', get_string('frontpageheading', 'theme_enlight'));

    /* Marketing Spot 1*/
    $name = 'theme_enlight_mspot1heading';
    $heading = get_string('marketingspot', 'theme_enlight').' 1 ('.get_string('aboutustxt', 'theme_enlight').')';
    $information = '';
    $setting = new admin_setting_heading($name, $heading, $information);
    $temp->add($setting);

    // Marketing Spot 1 Title.

    // Marketing Spot 1 Enable or disable.
    $name = 'theme_enlight/marketingSpot1_status';
    $title = get_string('marketingSpot1_status', 'theme_enlight');
    $description = get_string('marketingSpot1_statusdesc', 'theme_enlight');
   /* $yes = get_string('yes');
    $no = get_string('no');*/
    $default = 1;
    //$choices = array(1 => $yes , 0 => $no);
    $setting = new admin_setting_configcheckbox($name, $title, $description, $default);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);
    // Marketing Spot 1 Enable or disable.

    // Marketing Spot 1 Title.
    $name = 'theme_enlight/mspot1title';
    $title = get_string('title', 'theme_enlight');
    $description = get_string('mspottitledesc', 'theme_enlight', array('msno' => '1'));
    $default = 'lang:aboutus';
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Marketing Spot 1 Description.
    $name = 'theme_enlight/mspot1desc';
    $title = get_string('description');
    $description = get_string('mspotdescdesc', 'theme_enlight', array('msno' => '1'));
    $default = 'lang:aboutusdesc';
    $setting = new admin_setting_configtextarea($name, $title, $description, $default, PARAM_TEXT);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Marketing spot 1 Media content.
    $name = 'theme_enlight/mspot1media';
    $title = get_string('media', 'theme_enlight');
    $description = get_string('mspotmediadesc', 'theme_enlight', array('msno' => '1'));
    $default = '<iframe src="https://www.youtube.com/embed/zKD91RTMwK0" allowfullscreen="" width="560" height="315" frameborder="0"></iframe>';
    $setting = new admin_setting_confightmleditor($name, $title, $description, $default);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);
    /* Marketing Spot 1*/

    /* Marketing Spot 2*/
    $name = 'theme_enlight_mspot2heading';
    $heading = get_string('marketingspot', 'theme_enlight').' 2 ( '.get_string('learntitle', 'theme_enlight')." )";
    $information = '';
    $setting = new admin_setting_heading($name, $heading, $information);
    $temp->add($setting);

    $name = 'theme_enlight/marketingSpot2_status';
    $title = get_string('marketingSpot2_status', 'theme_enlight');
    $description = get_string('marketingSpot2_statusdesc', 'theme_enlight');
    $default = 1;
    $setting = new admin_setting_configcheckbox($name, $title, $description, $default);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Marketing Spot 2 Title.
    $name = 'theme_enlight/mspot2title';
    $title = get_string('title', 'theme_enlight');
    $description = get_string('mspottitledesc', 'theme_enlight', array('msno' => '2'));
    $default = 'lang:learnanytime';
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Marketing Spot 2 Description.
    $name = 'theme_enlight/mspot2desc';
    $title = get_string('description');
    $description = get_string('mspotdescdesc', 'theme_enlight', array('msno' => '2'));
    $default = 'lang:learnanytimedesc';
    $setting = new admin_setting_configtextarea($name, $title, $description, $default, PARAM_TEXT);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

 // Marketing Spot 2 Link Text.
    $name = 'theme_enlight/mspot2urltext';
    $title = get_string('button', 'theme_enlight').' '.get_string('text', 'theme_enlight');
    $description = get_string('mspot2urltxtdesc', 'theme_enlight', array('msno' => '2'));
    $default = 'lang:viewallcourses';
    $setting = new admin_setting_configtext($name, $title, $description, $default, PARAM_TEXT);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Marketing Spot 2 Link.
    $name = 'theme_enlight/mspot2url';
    $title = get_string('button', 'theme_enlight').' '.get_string('link', 'theme_enlight');
    $description = get_string('mspot2urldesc', 'theme_enlight');
    $default = 'http://www.example.com/';
    $setting = new admin_setting_configtext($name, $title, $description, $default, PARAM_URL);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    $name = 'theme_enlight/mspot2urltarget';
    $title = get_string('button', 'theme_enlight').' '.get_string('target', 'theme_enlight');
    $description = get_string('mspot2urltarget_desc', 'theme_enlight');
    $same = get_string('sameWindow', 'theme_enlight');
    $new = get_string('newWindow', 'theme_enlight');
    $default = 1;
    $choices = array(0 => $same , 1 => $new);
    $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);


    /* Marketing Spot 2*/
$settings->add($temp);
    //$ADMIN->add('theme_enlight', $temp);
    /* Front Page Settings End */

    /* Category Image */
    $temp = new admin_settingpage('theme_enlight_categoryimg', get_string('categoryimgheading', 'theme_enlight'));

    $temp->add(new admin_setting_heading('theme_enlight_categoryimg', get_string('categoryimgheadingsub', 'theme_enlight'),
    format_text(get_string('categoryimgdesc', 'theme_enlight'), FORMAT_MARKDOWN)));
    // Get all category IDs and their pretty names.

    require_once($CFG->libdir . '/coursecatlib.php');
    $coursecats = coursecat::make_categories_list();

    // Go through all categories and create the necessary settings.
    foreach ($coursecats as $key => $value) {
        // Category Icons for each category.
        $name = 'theme_enlight/categoryimg';
        $title = $value;
        $description = get_string('categoryimgcategory', 'theme_enlight', array('category' => $value));
        $default = 'categoryimg'.$key;
        $setting = new admin_setting_configstoredfile($name . $key, $title, $description, $default);
        $setting->set_updatedcallback('theme_reset_all_caches');
        $temp->add($setting);
    }
    unset($coursecats);
    $settings->add($temp);


    // Our Team.
    $temp = new admin_settingpage('theme_enlight_ourTeam', get_string('ourTeam', 'theme_enlight'));
    $temp->add(new admin_setting_heading('theme_enlight_ourTeam', get_string('ourTeamhead_sub', 'theme_enlight'),
    format_text(get_string('ourTeamdesc', 'theme_enlight'), FORMAT_MARKDOWN)));

    $name = 'theme_enlight/ourteamStatus';
    $title = get_string('activateblock', 'theme_enlight');
    $description = get_string('ourteamStatus_desc', 'theme_enlight');
    $default = 0;
    $setting = new admin_setting_configcheckbox($name, $title, $description, $default);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    $name = 'theme_enlight/ourteamTitle';
    $title = get_string('title', 'theme_enlight');
    $description = get_string('ourteamTitle_desc', 'theme_enlight');
    $default = 'lang:ourTeam';
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Auto Scroll.
    $name = 'theme_enlight/ourteamAutoplay';
    $title = get_string('testimonialAutoplay', 'theme_enlight');
    $description = get_string('ourteamAutoplay_desc', 'theme_enlight');
    $yes = get_string('yes');
    $no = get_string('no');
    $default = 0;
    $choices = array(1 => $yes , 0 => $no);
    $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    $name = 'theme_enlight/numberofpersons';
    $title = get_string('numberofpersons', 'theme_enlight');
    $description = get_string('numberofpersons_desc', 'theme_enlight');
    $default = 1;
    $choices = array(
        1 => '1',
        2 => '2',
        3 => '3',
        4 => '4',
        5 => '5',
        6 => '6',
        7 => '7',
        8 => '8',
        9 => '9',
        10 => '10',
        11 => '11',
        12 => '12',
        13 => '13',
        14 => '14',
        15 => '15',
        16 => '16',
        64 => '64',
        98 => '98',
        112 => '112'
    );
    $temp->add(new admin_setting_configselect($name, $title, $description, $default, $choices));
    // No of testimonials.
    $numberofpersons = get_config('theme_enlight', 'numberofpersons');
    for ($i = 1; $i <= $numberofpersons ; $i++) {

        $name = 'theme_enlight/team' . $i . 'info';
        $heading = get_string('team', 'theme_enlight', array('team' => $i));
        $information = get_string('teamdesc', 'theme_enlight', array('team' => $i));
        $setting = new admin_setting_heading($name, $heading, $information);
        $temp->add($setting);

        $name = 'theme_enlight/team' . $i . 'pname';
        $title = get_string('name', 'theme_enlight');
        $description = get_string('teamunamedesc', 'theme_enlight');
        $default = '';
        $setting = new admin_setting_configtext($name, $title, $description, $default, PARAM_TEXT);
        // $setting->set_updatedcallback('theme_reset_all_caches');
        $temp->add($setting);

        $name = 'theme_enlight/team' . $i . 'position';
        $title = get_string('teamposition', 'theme_enlight');
        $description = get_string('teamposition_desc', 'theme_enlight');
        $default = '';
        $setting = new admin_setting_configtext($name, $title, $description, $default, PARAM_TEXT);
        // $setting->set_updatedcallback('theme_reset_all_caches');
        $temp->add($setting);

        $name = 'theme_enlight/team' . $i . 'profileUrl';
        $title = get_string('userprofileUrl', 'theme_enlight');
        $description = get_string('userprofileUrl_desc', 'theme_enlight');
        $default = '';
        $setting = new admin_setting_configtext($name, $title, $description, $default, PARAM_TEXT);
        // $setting->set_updatedcallback('theme_reset_all_caches');
        $temp->add($setting);

        // Social media icon 1 - name.
    $name = 'theme_enlight/team'.$i.'socialIcon1';
    $title = get_string('teamSocialicon', 'theme_enlight').' 1 ';
    $description = get_string('teamSocialicon_desc', 'theme_enlight', array('icon' => 'facebook'));
    $default = get_string('team_socialicon1default', 'theme_enlight');
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Social Media Icon Url 1.
    $name = 'theme_enlight/team'.$i.'sIconurl1';
    $title = get_string('teamSocialicon', 'theme_enlight').' 1 '.get_string('url', 'theme_enlight');
    $description = get_string('team_siconurl_desc', 'theme_enlight', array('icon' => 'facebook'));
    $default = get_string('siconurl4default', 'theme_enlight');
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    $temp->add($setting);

// scoial icon 2
    $name = 'theme_enlight/team'.$i.'socialIcon2';
    $title = get_string('teamSocialicon', 'theme_enlight').' 2 ';
    $description = get_string('teamSocialicon_desc', 'theme_enlight', array('icon' => 'twitter'));
    $default = get_string('team_socialicon2default', 'theme_enlight');
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Social Media Icon Url 1.
    $name = 'theme_enlight/team'.$i.'sIconurl2';
    $title = get_string('teamSocialicon', 'theme_enlight').' 2 '.get_string('url', 'theme_enlight');
    $description = get_string('team_siconurl_desc', 'theme_enlight', array('icon' => 'twitter'));
    $default = get_string('siconurl1default', 'theme_enlight');
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    $temp->add($setting);

/// Social Icon 3
    $name = 'theme_enlight/team'.$i.'socialIcon3';
    $title = get_string('teamSocialicon', 'theme_enlight').' 3 ';
    $description = get_string('teamSocialicon_desc', 'theme_enlight', array('icon' => 'google-plus'));
    $default = get_string('team_socialicon3default', 'theme_enlight');
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Social Media Icon Url 3.
    $name = 'theme_enlight/team'.$i.'sIconurl3';
    $title = get_string('teamSocialicon', 'theme_enlight').' 3 '.get_string('url', 'theme_enlight');
    $description = get_string('team_siconurl_desc', 'theme_enlight', array('icon' => 'google'));
    $default = get_string('team_siconurl3default', 'theme_enlight');
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    $temp->add($setting);

/// Social icon 4
    $name = 'theme_enlight/team'.$i.'socialIcon4';
    $title = get_string('teamSocialicon', 'theme_enlight').' 4 ';
    $description = get_string('teamSocialicon_desc', 'theme_enlight', array('icon' => 'pinterest-p'));
    $default = get_string('team_socialicon4default', 'theme_enlight');
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Social Media Icon Url 3.
    $name = 'theme_enlight/team'.$i.'sIconurl4';
    $title = get_string('teamSocialicon', 'theme_enlight').' 4 '.get_string('url', 'theme_enlight');
    $description = get_string('team_siconurl_desc', 'theme_enlight', array('icon' => 'pinterest'));
    $default = get_string('team_siconurl4default', 'theme_enlight');
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    $temp->add($setting);

        $name = 'theme_enlight/team' . $i . 'description';
        $title = get_string('teamdesc', 'theme_enlight');
        $description = get_string('teamDesc_desc', 'theme_enlight');
        $default = '';
        $setting = new admin_setting_configtextarea($name, $title, $description, $default, PARAM_TEXT);
        // $setting->set_updatedcallback('theme_reset_all_caches');
        $temp->add($setting);

        $name = 'theme_enlight/team'.$i.'img';
        $title = get_string('teamImg', 'theme_enlight');
        $description = get_string('teamImg_desc', 'theme_enlight');
        $default = 'team'.$i.'img';
        $setting = new admin_setting_configstoredfile($name, $title, $description, $default);
        $setting->set_updatedcallback('theme_reset_all_caches');
        $temp->add($setting);
    }
    $settings->add($temp);



    /*Testimonials Start*/
    $temp = new admin_settingpage('theme_enlight_tmonialhead', get_string('tmonialheading', 'theme_enlight'));

     $name = 'theme_enlight_testimonials';
    $heading = get_string('testiGeneral', 'theme_enlight');
    $information = get_string('tmonialheadingsub_desc', 'theme_enlight');
    $setting = new admin_setting_heading($name, $heading, $information);
    $temp->add($setting);

    // Display Slideshow.
    $name = 'theme_enlight/toggletmonial';
    $title = get_string('toggletmonial', 'theme_enlight');
    $description = get_string('toggletmonialdesc', 'theme_enlight');
    $default = 1;
    $setting = new admin_setting_configcheckbox($name, $title, $description, $default);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    $name = 'theme_enlight/tmonialTraversal_status';
    $title = get_string('tmonialTraversal_status', 'theme_enlight');
    $description = get_string('tmonialTraversal_statusdesc', 'theme_enlight');
    $yes = get_string('yes');
    $no = get_string('no');
    $default = 1;
    $choices = array(1 => $yes , 0 => $no);
    $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Auto Scroll.
    $name = 'theme_enlight/testimonialAutoplay';
    $title = get_string('testimonialAutoplay', 'theme_enlight');
    $description = get_string('testimonialAutoplay_desc', 'theme_enlight');
    $yes = get_string('yes');
    $no = get_string('no');
    $default = 1;
    $choices = array(1 => $yes , 0 => $no);
    $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    $name = 'theme_enlight/numberoftmonials';
    $title = get_string('numberoftmonials', 'theme_enlight');
    $description = get_string('numberoftmonials_desc', 'theme_enlight');
    $default = 1;
    $choices = array(
        1 => '1',
        2 => '2',
        3 => '3',
        4 => '4',
        5 => '5',
        6 => '6',
        7 => '7',
        8 => '8',
        9 => '9',
        10 => '10',
        11 => '11',
        12 => '12',
        13 => '13',
        14 => '14',
        15 => '15',
        16 => '16'
    );
    $temp->add(new admin_setting_configselect($name, $title, $description, $default, $choices));
    // No of testimonials.
    $numberoftmonials = get_config('theme_enlight', 'numberoftmonials');

    for ($i = 1; $i <= $numberoftmonials; $i++) {
        // Testimonial Heading.
        $name = 'theme_enlight/testimonialno' . $i . 'info';
        $heading = get_string('testimonialno', 'theme_enlight', array('tmonial' => $i));
        $information = get_string('testimonialnodesc', 'theme_enlight', array('tmonial' => $i));
        $setting = new admin_setting_heading($name, $heading, $information);
        $temp->add($setting);

        // User Name.
        $name = 'theme_enlight/tmonial' . $i . 'uname';
        $title = get_string('tmonialuname', 'theme_enlight');
        $description = get_string('tmonialunamedesc', 'theme_enlight');
        $default = ($i == 1) ? get_string('tmonialuname_default', 'theme_enlight') : '';
        $setting = new admin_setting_configtext($name, $title, $description, $default, PARAM_TEXT);
        // $setting->set_updatedcallback('theme_reset_all_caches');
        $temp->add($setting);

        // Testimonial Image.
        $name = 'theme_enlight/tmonial'. $i . 'img';
        $title = get_string('tmonialimg', 'theme_enlight');
        $description = get_string('tmonialimgdesc', 'theme_enlight');
        $default = 'tmonial'. $i . 'img';
        $setting = new admin_setting_configstoredfile($name , $title, $description, $default);
        $setting->set_updatedcallback('theme_reset_all_caches');
        $temp->add($setting);

        // Testimonial text.
        $name = 'theme_enlight/tmonial' . $i . 'text';
        $title = get_string('tmonialtext', 'theme_enlight');
        $description = get_string('tmonialtextdesc', 'theme_enlight');
        $default = ($i == 1) ? get_string('tmonialtext_default', 'theme_enlight') : '';
        $setting = new admin_setting_configtextarea($name, $title, $description, $default, PARAM_TEXT);
        // $setting->set_updatedcallback('theme_reset_all_caches');
        $temp->add($setting);

    }

    $settings->add($temp);

    /*Testimonials End*/

    /* Footer Settings start */
    $temp = new admin_settingpage('theme_enlight_footer', get_string('footerheading', 'theme_enlight'));

    /* Footer Block1 */
    $name = 'theme_enlight_footerblock1heading';
    $heading = get_string('footerblock', 'theme_enlight').' 1 ';
    $information = '';
    $setting = new admin_setting_heading($name, $heading, $information);
    $temp->add($setting);

     $name = 'theme_enlight/footerb1_status';
    $title = get_string('activateblock', 'theme_enlight');
    $description = get_string('footerb1_statusdesc', 'theme_enlight');
    $default = 1;
    $setting = new admin_setting_configcheckbox($name, $title, $description, $default);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    $name = 'theme_enlight/footerbtitle1';
    $title = get_string('title', 'theme_enlight');
    $description = get_string('footerbtitledesc', 'theme_enlight');
    $default = 'lang:footerbtitle1default';
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    $name = 'theme_enlight/footerdesc1';
    $title = get_string('teamdesc', 'theme_enlight');
    $description = get_string('footerdescription_desc', 'theme_enlight', array('blockno' => '1'));
    $default = get_string('footerblink1default', 'theme_enlight');
    $setting = new admin_setting_confightmleditor($name, $title, $description, $default);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);
    /* Footer Block1 */

    /* Footer Block2*/
    $name = 'theme_enlight_footerblock2heading';
    $heading = get_string('footerblock', 'theme_enlight').' 2 ';
    $information = '';
    $setting = new admin_setting_heading($name, $heading, $information);
    $temp->add($setting);

    $name = 'theme_enlight/footerb2_status';
    $title = get_string('activateblock', 'theme_enlight');
    $description = get_string('footerb1_statusdesc', 'theme_enlight');
    $default = 1;
    $setting = new admin_setting_configcheckbox($name, $title, $description, $default);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    $name = 'theme_enlight/footerbtitle2';
    $title = get_string('title', 'theme_enlight');
    $description = get_string('footerbtitledesc', 'theme_enlight');
    $default = 'lang:footerbtitle2default';
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    $name = 'theme_enlight/footerblink2';
    $title = get_string('links', 'theme_enlight');
    $description = get_string('footerblink_desc', 'theme_enlight', array('blockno' => '2'));
    $default = get_string('footerblink2default', 'theme_enlight');
    $setting = new admin_setting_configtextarea($name, $title, $description, $default);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);
    /* Footer Block2 */

    /* Footer Block3 */

    $name = 'theme_enlight_footerblock3heading';
    $heading = get_string('footerblock', 'theme_enlight').' 3 ';
    $information = '';
    $setting = new admin_setting_heading($name, $heading, $information);
    $temp->add($setting);

    //  Footer block 3 status
    $name = 'theme_enlight/footerb3_status';
    $title = get_string('activateblock', 'theme_enlight');
    $description = get_string('footerb1_statusdesc', 'theme_enlight');
    $default = 1;
    $setting = new admin_setting_configcheckbox($name, $title, $description, $default);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Footer block title 3
    $name = 'theme_enlight/footerbtitle3';
    $title = get_string('title', 'theme_enlight');
    $description = get_string('footerbtitledesc', 'theme_enlight');
    $default = 'lang:footerbtitle3default';
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Footer block 3 link
    $name = 'theme_enlight/footerblink3';
    $title = get_string('links', 'theme_enlight');
    $description = get_string('footerblink_desc', 'theme_enlight', array('blockno' => '3'));
    $default = get_string('footerblink3default', 'theme_enlight');
    $setting = new admin_setting_configtextarea($name, $title, $description, $default);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);
    /* Footer Block3 */

    /* Footer Block4 */
    $name = 'theme_enlight_footerblock4heading';
    $heading = get_string('footerblock', 'theme_enlight').' 4 ';
    $information = get_string('socialmediadesc', 'theme_enlight');
    $setting = new admin_setting_heading($name, $heading, $information);
    $temp->add($setting);

    //  Footer block 4 status
    $name = 'theme_enlight/footerb4_status';
    $title = get_string('activateblock', 'theme_enlight');
    $description = get_string('footerb1_statusdesc', 'theme_enlight');
    $default = 1;
    $setting = new admin_setting_configcheckbox($name, $title, $description, $default);
    $temp->add($setting);

    // Footer block 4 Title.
    $name = 'theme_enlight/footerbtitle4';
    $title = get_string('title', 'theme_enlight');
    $description = get_string('footerbtitledesc', 'theme_enlight');
    $default = 'lang:footerbtitle4default';
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    $temp->add($setting);

    // Footer Address.
    $name = 'theme_enlight/footaddress';
    $title = get_string('address', 'theme_enlight');
    $description = get_string('address_desc', 'theme_enlight');
    $default = get_string('defaultaddress','theme_enlight');
    $setting = new admin_setting_configtextarea($name, $title, $description, $default);
    $temp->add($setting);

    // Footer Email Id.
    $name = 'theme_enlight/footemailid';
    $title = get_string('emailid', 'theme_enlight');
    $description = '';
    $default = get_string('defaultemailid','theme_enlight');
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    $temp->add($setting);

    // Footer phone number.
    $name = 'theme_enlight/footphoneno';
    $title = get_string('phoneno', 'theme_enlight');
    $description = '';
    $default = get_string('defaultphoneno','theme_enlight');
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    $temp->add($setting);

    // Enable / Disable social media icon 1.
    $name = 'theme_enlight/siconenable1';
    $title = get_string('enable', 'theme_enlight').' '.get_string('socialicon', 'theme_enlight').' 1 ';
    $description = '';
    $default = 1;
    $setting = new admin_setting_configcheckbox($name, $title, $description, $default);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Social media icon 1 - name.
    $name = 'theme_enlight/socialicon1';
    $title = get_string('socialicon', 'theme_enlight').' 1 ';
    $description = get_string('socialicondesc', 'theme_enlight');
    $default = get_string('socialicon1default', 'theme_enlight');
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Social media icon 1 - Background color.
    $name = 'theme_enlight/siconbgc1';
    $title = get_string('socialicon', 'theme_enlight').' 1 '.get_string('bgcolor', 'theme_enlight');
    $description = get_string('siconbgcdesc', 'theme_enlight');
    $default = get_string('siconbgc1default', 'theme_enlight');
    $previewconfig = null;
    $setting = new admin_setting_configcolourpicker($name, $title, $description, $default, $previewconfig);
    $temp->add($setting);

    // Social Media Icon Url 1.
    $name = 'theme_enlight/siconurl1';
    $title = get_string('socialicon', 'theme_enlight').' 1 '.get_string('url', 'theme_enlight');
    $description = get_string('siconurldesc', 'theme_enlight');
    $default = get_string('siconurl1default', 'theme_enlight');
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    $temp->add($setting);

    // Enable / Disable social media icon 2.
    $name = 'theme_enlight/siconenable2';
    $title = get_string('enable', 'theme_enlight').' '.get_string('socialicon', 'theme_enlight').' 2 ';
    $description = '';
    $default = 1;
    $setting = new admin_setting_configcheckbox($name, $title, $description, $default);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Social media icon 2 - name.
    $name = 'theme_enlight/socialicon2';
    $title = get_string('socialicon', 'theme_enlight').' 2 ';
    $description = get_string('socialicondesc', 'theme_enlight');
    $default = get_string('socialicon2default', 'theme_enlight');
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Social media icon 2 - Background color.
    $name = 'theme_enlight/siconbgc2';
    $title = get_string('socialicon', 'theme_enlight').' 2 '.get_string('bgcolor', 'theme_enlight');
    $description = get_string('siconbgcdesc', 'theme_enlight');
    $default = get_string('siconbgc2default', 'theme_enlight');
    $previewconfig = null;
    $setting = new admin_setting_configcolourpicker($name, $title, $description, $default, $previewconfig);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Social Media Icon Url 2.
    $name = 'theme_enlight/siconurl2';
    $title = get_string('socialicon', 'theme_enlight').' 2 '.get_string('url', 'theme_enlight');
    $description = get_string('siconurldesc', 'theme_enlight');
    $default = get_string('siconurl2default', 'theme_enlight');
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    $temp->add($setting);

    // Enable / Disable social media icon 3.
    $name = 'theme_enlight/siconenable3';
    $title = get_string('enable', 'theme_enlight').' '.get_string('socialicon', 'theme_enlight').' 3 ';
    $description = '';
    $default = 1;
    $setting = new admin_setting_configcheckbox($name, $title, $description, $default);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Social media icon 3 - name.
    $name = 'theme_enlight/socialicon3';
    $title = get_string('socialicon', 'theme_enlight').' 3 ';
    $description = get_string('socialicondesc', 'theme_enlight');
    $default = get_string('socialicon3default', 'theme_enlight');
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Social media icon 3 - Background color.
    $name = 'theme_enlight/siconbgc3';
    $title = get_string('socialicon', 'theme_enlight').' 3 '.get_string('bgcolor', 'theme_enlight');
    $description = get_string('siconbgcdesc', 'theme_enlight');
    $default = get_string('siconbgc3default', 'theme_enlight');
    $previewconfig = null;
    $setting = new admin_setting_configcolourpicker($name, $title, $description, $default, $previewconfig);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Social Media Icon Url 3.
    $name = 'theme_enlight/siconurl3';
    $title = get_string('socialicon', 'theme_enlight').' 3 '.get_string('url', 'theme_enlight');
    $description = get_string('siconurldesc', 'theme_enlight');
    $default = get_string('siconurl3default', 'theme_enlight');
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    $temp->add($setting);

    // Enable / Disable social media icon 4.
    $name = 'theme_enlight/siconenable4';
    $title = get_string('enable', 'theme_enlight').' '.get_string('socialicon', 'theme_enlight').' 4 ';
    $description = '';
    $default = 1;
    $setting = new admin_setting_configcheckbox($name, $title, $description, $default);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Social media icon 4 - name.
    $name = 'theme_enlight/socialicon4';
    $title = get_string('socialicon', 'theme_enlight').' 4 ';
    $description = get_string('socialicondesc', 'theme_enlight');
    $default = get_string('socialicon4default', 'theme_enlight');
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Social media icon 4 - Background color.
    $name = 'theme_enlight/siconbgc4';
    $title = get_string('socialicon', 'theme_enlight').' 4 '.get_string('bgcolor', 'theme_enlight');
    $description = get_string('siconbgcdesc', 'theme_enlight');
    $default = get_string('siconbgc4default', 'theme_enlight');
    $previewconfig = null;
    $setting = new admin_setting_configcolourpicker($name, $title, $description, $default, $previewconfig);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Social Media Icon Url 4.
    $name = 'theme_enlight/siconurl4';
    $title = get_string('socialicon', 'theme_enlight').' 4 '.get_string('url', 'theme_enlight');
    $description = get_string('siconurldesc', 'theme_enlight');
    $default = get_string('siconurl4default', 'theme_enlight');
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    $temp->add($setting);
    /* Footer Block4 */

    // Copyright.
    $name = 'theme_enlight_copyrightheading';
    $heading = get_string('copyrightheading', 'theme_enlight');
    $information = '';
    $setting = new admin_setting_heading($name, $heading, $information);
    $temp->add($setting);

    // Copyright setting.
    $name = 'theme_enlight/copyright';
    $title = get_string('copyright', 'theme_enlight');
    $description = get_string('copyrightdesc', 'theme_enlight');
    $default = 'lang:copyrightdefault';
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    $temp->add($setting);

    //$ADMIN->add('theme_enlight', $temp);
    $settings->add($temp);
    /* Footer Settings end */

}